/*******************************************************************************
 * Copyright (c) 2011-2013 Gerd W&uuml;therich (gerd@gerd-wuetherich.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gerd W&uuml;therich (gerd@gerd-wuetherich.de) - initial API and implementation
 ******************************************************************************/
package com.wuetherich.osgi.ds.annotations;

import org.osgi.service.component.annotations.Component;

public interface Constants {

  /** - */
  final String BUNDLE_ID                                 = "com.wuetherich.osgi.ds.annotations";

  /** - */
  final String BUILDER_ID                                = "com.wuetherich.osgi.ds.annotations.dsAnnotationBuilder";

  /** - */
  final String NATURE_ID                                 = "com.wuetherich.osgi.ds.annotations.dsAnnotationNature";

  /** - */
  final String BUNDLE_HEADER_SERVICE_COMPONENT           = "Service-Component";

  /** - */
  final String COMPONENT_DESCRIPTION_FOLDER              = "OSGI-INF";

  /** - */
  final String DS_ANNOTATION_PROBLEM_MARKER              = "com.wuetherich.osgi.ds.annotations.dsAnnotationProblem";

  /** - */
  final String DS_ANNOTATION_PACKAGE                     = Component.class.getPackage().getName();

  /** - */
  final String DS_ANNOTATION_BUILDER_GENERATED_COMMENT_REGEXP    = "(Generated by DS Annotation Builder \\[)(.*)(\\])";

  /** - */
  final String DS_ANNOTATION_BUILDER_GENERATED_COMMENT   = "<!--Generated by DS Annotation Builder [%s]-->\n";

  /** - */
  final String PREF_DS_VERSION                           = "com.wuetherich.osgi.ds.annotations.componentversion";

  /** - */
  final String PREF_MARK_COMPONENT_DESCRIPTOR_AS_DERIVED = "com.wuetherich.osgi.ds.annotations.derived";
}
