/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.preferences;

import com.wuetherich.osgi.ds.annotations.DsAnnotationVersion;
import com.wuetherich.osgi.ds.annotations.internal.preferences.fwk.AbstractPropertyAndPreferencesPage;
import com.wuetherich.osgi.ds.annotations.internal.preferences.fwk.ConfigurationBlock;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class DsAnnotationsPropertyAndPreferenceConfigurationBlock
extends ConfigurationBlock {
    private Button _button_1_0;
    private Button _button_1_1;
    private Button _button_1_2;
    private Button _button_markAsDerived;

    public DsAnnotationsPropertyAndPreferenceConfigurationBlock(Composite parent, AbstractPropertyAndPreferencesPage page) {
        super(parent, 0, page);
    }

    @Override
    protected void createContent() {
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        Group group1 = new Group((Composite)this, 4);
        group1.setText("Service Component Version");
        group1.setLayout((Layout)DsAnnotationsPropertyAndPreferenceConfigurationBlock.createRowLayout());
        GridData data = new GridData(4, 128, true, false);
        group1.setLayoutData((Object)data);
        this._button_1_0 = new Button((Composite)group1, 16);
        this._button_1_0.setText("1.1 (OSGi Release 4.0/4.1)");
        this._button_1_1 = new Button((Composite)group1, 16);
        this._button_1_1.setText("1.1 (OSGi Release 4.2)");
        this._button_1_2 = new Button((Composite)group1, 16);
        this._button_1_2.setText("1.2 (OSGi Release 4.3+)");
        this._button_markAsDerived = new Button((Composite)this, 32);
        this._button_markAsDerived.setText("Mark generated component descriptors as derived");
    }

    @Override
    public void initialize() {
        switch (this.getDsAnnotationVersion(false)) {
            case V_1_0: {
                this._button_1_0.setSelection(true);
                break;
            }
            case V_1_1: {
                this._button_1_1.setSelection(true);
                break;
            }
            case V_1_2: {
                this._button_1_2.setSelection(true);
                break;
            }
        }
        this._button_markAsDerived.setSelection(this.getMarkGeneratedDescriptorsAsDerived(false));
    }

    @Override
    public void performDefaults() {
        switch (this.getDsAnnotationVersion(true)) {
            case V_1_0: {
                this._button_1_0.setSelection(true);
                break;
            }
            case V_1_1: {
                this._button_1_1.setSelection(true);
                break;
            }
            case V_1_2: {
                this._button_1_2.setSelection(true);
                break;
            }
        }
        this._button_markAsDerived.setSelection(this.getMarkGeneratedDescriptorsAsDerived(true));
    }

    @Override
    protected String[] getPreferenceKeys() {
        return new String[]{"com.wuetherich.osgi.ds.annotations.componentversion", "com.wuetherich.osgi.ds.annotations.derived"};
    }

    @Override
    public boolean performOk() {
        DsAnnotationVersion dsAnnotationVersion = DsAnnotationVersion.V_1_2;
        if (this._button_1_0.getSelection()) {
            dsAnnotationVersion = DsAnnotationVersion.V_1_0;
        } else if (this._button_1_1.getSelection()) {
            dsAnnotationVersion = DsAnnotationVersion.V_1_1;
        } else if (this._button_1_2.getSelection()) {
            dsAnnotationVersion = DsAnnotationVersion.V_1_2;
        }
        this.getPage().getPreferenceStore().putValue("com.wuetherich.osgi.ds.annotations.componentversion", dsAnnotationVersion.name());
        this.getPage().getPreferenceStore().putValue("com.wuetherich.osgi.ds.annotations.derived", Boolean.toString(this._button_markAsDerived.getSelection()));
        return true;
    }

    private DsAnnotationVersion getDsAnnotationVersion(boolean getDefault) {
        String version = getDefault ? this.getPage().getPreferenceStore().getDefaultString("com.wuetherich.osgi.ds.annotations.componentversion") : this.getPage().getPreferenceStore().getString("com.wuetherich.osgi.ds.annotations.componentversion");
        DsAnnotationVersion annotationVersion = DsAnnotationVersion.valueOf((String)version);
        return annotationVersion;
    }

    private boolean getMarkGeneratedDescriptorsAsDerived(boolean getDefault) {
        return getDefault ? this.getPage().getPreferenceStore().getDefaultBoolean("com.wuetherich.osgi.ds.annotations.derived") : this.getPage().getPreferenceStore().getBoolean("com.wuetherich.osgi.ds.annotations.derived");
    }

    private static RowLayout createRowLayout() {
        RowLayout layout = new RowLayout(512);
        layout.spacing = 10;
        layout.marginTop = 10;
        layout.marginBottom = 10;
        layout.fill = true;
        return layout;
    }
}

