/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.preferences.fwk;

import com.wuetherich.osgi.ds.annotations.DsAnnotationsCore;
import com.wuetherich.osgi.ds.annotations.internal.preferences.fwk.StatusInfo;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class ProjectSelectionDialog
extends SelectionStatusDialog {
    private TableViewer _tableViewer;
    private Set<IProject> _projectsWithSpecifics;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private ViewerFilter fFilter;

    public ProjectSelectionDialog(Shell parentShell, Set<IProject> projectsWithSpecifics) {
        super(parentShell);
        this.setTitle("Project Specific Configuration");
        this.setMessage("Select the project to configure:");
        this._projectsWithSpecifics = projectsWithSpecifics;
        this.fFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ProjectSelectionDialog.this._projectsWithSpecifics.contains(element);
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Font font = parent.getFont();
        composite.setFont(font);
        this.createMessageArea(composite);
        this._tableViewer = new TableViewer(composite, 2816);
        this._tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectSelectionDialog.this.doSelectionChanged(((IStructuredSelection)event.getSelection()).toArray());
            }
        });
        this._tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectSelectionDialog.this.okPressed();
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 250;
        data.widthHint = 300;
        this._tableViewer.getTable().setLayoutData((Object)data);
        this._tableViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
            }

            public String getText(Object element) {
                return ((IProject)element).getName();
            }
        });
        this._tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._tableViewer.setComparator(new ViewerComparator());
        this._tableViewer.getControl().setFont(font);
        this._tableViewer.setInput((Object)DsAnnotationsCore.getDsAnnotationAwareProjects());
        this.doSelectionChanged(new Object[0]);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doSelectionChanged(Object[] objects) {
        if (objects.length != 1) {
            this.updateStatus(new StatusInfo(4, ""));
            this.setSelectionResult(null);
        } else {
            this.updateStatus(new StatusInfo());
            this.setSelectionResult(objects);
        }
    }

    protected void computeResult() {
    }
}

