/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.preferences;

import com.wuetherich.osgi.ds.annotations.Constants;
import com.wuetherich.osgi.ds.annotations.DsAnnotationVersion;
import com.wuetherich.osgi.ds.annotations.internal.preferences.fwk.AbstractPropertyAndPreferencesPage;
import com.wuetherich.osgi.ds.annotations.internal.preferences.fwk.ConfigurationBlock;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class DsAnnotationsPropertyAndPreferenceConfigurationBlock
extends ConfigurationBlock {
    private Button _button_1_0;
    private Button _button_1_1;
    private Button _button_1_2;
    private Button _button_markAsDerived;

    public DsAnnotationsPropertyAndPreferenceConfigurationBlock(Composite parent, AbstractPropertyAndPreferencesPage page) {
        super(parent, 0, page);
    }

    @Override
    protected void createContent() {
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        Group group1 = new Group((Composite)this, 4);
        group1.setText("Service Component Version");
        group1.setLayout((Layout)DsAnnotationsPropertyAndPreferenceConfigurationBlock.createRowLayout());
        GridData data = new GridData(4, 128, true, false);
        group1.setLayoutData((Object)data);
        this._button_1_0 = new Button((Composite)group1, 16);
        this._button_1_0.setText(DsAnnotationVersion.V_1_0.getDescription());
        this._button_1_1 = new Button((Composite)group1, 16);
        this._button_1_1.setText(DsAnnotationVersion.V_1_1.getDescription());
        this._button_1_2 = new Button((Composite)group1, 16);
        this._button_1_2.setText(DsAnnotationVersion.V_1_2.getDescription());
        this._button_markAsDerived = new Button((Composite)this, 32);
        this._button_markAsDerived.setText("Mark generated component descriptors as derived");
    }

    @Override
    public void initialize() {
        switch (this.getDsAnnotationVersion(false)) {
            case V_1_0: {
                this._button_1_0.setSelection(true);
                break;
            }
            case V_1_1: {
                this._button_1_1.setSelection(true);
                break;
            }
            case V_1_2: {
                this._button_1_2.setSelection(true);
                break;
            }
        }
        this._button_markAsDerived.setSelection(this.getMarkGeneratedDescriptorsAsDerived(false));
    }

    @Override
    public void performDefaults() {
        switch (this.getDsAnnotationVersion(true)) {
            case V_1_0: {
                this._button_1_0.setSelection(true);
                break;
            }
            case V_1_1: {
                this._button_1_1.setSelection(true);
                break;
            }
            case V_1_2: {
                this._button_1_2.setSelection(true);
                break;
            }
        }
        this._button_markAsDerived.setSelection(this.getMarkGeneratedDescriptorsAsDerived(true));
    }

    @Override
    protected String[] getPreferenceKeys() {
        return new String[]{Constants.PREF_DS_VERSION, Constants.PREF_MARK_COMPONENT_DESCRIPTOR_AS_DERIVED};
    }

    @Override
    public boolean performOk() {
        DsAnnotationVersion dsAnnotationVersion = DsAnnotationVersion.V_1_2;
        if (this._button_1_0.getSelection()) {
            dsAnnotationVersion = DsAnnotationVersion.V_1_0;
        } else if (this._button_1_1.getSelection()) {
            dsAnnotationVersion = DsAnnotationVersion.V_1_1;
        } else if (this._button_1_2.getSelection()) {
            dsAnnotationVersion = DsAnnotationVersion.V_1_2;
        }
        this.getPage().getPreferenceStore().putValue(Constants.PREF_DS_VERSION, dsAnnotationVersion.name());
        this.getPage().getPreferenceStore().putValue(Constants.PREF_MARK_COMPONENT_DESCRIPTOR_AS_DERIVED, Boolean.toString(this._button_markAsDerived.getSelection()));
        return true;
    }

    private DsAnnotationVersion getDsAnnotationVersion(boolean getDefault) {
        String version = getDefault ? this.getPage().getPreferenceStore().getDefaultString(Constants.PREF_DS_VERSION) : this.getPage().getPreferenceStore().getString(Constants.PREF_DS_VERSION);
        DsAnnotationVersion annotationVersion = DsAnnotationVersion.valueOf((String)version);
        return annotationVersion;
    }

    private boolean getMarkGeneratedDescriptorsAsDerived(boolean getDefault) {
        return getDefault ? this.getPage().getPreferenceStore().getDefaultBoolean(Constants.PREF_MARK_COMPONENT_DESCRIPTOR_AS_DERIVED) : this.getPage().getPreferenceStore().getBoolean(Constants.PREF_MARK_COMPONENT_DESCRIPTOR_AS_DERIVED);
    }

    private static RowLayout createRowLayout() {
        RowLayout layout = new RowLayout(512);
        layout.spacing = 10;
        layout.marginTop = 10;
        layout.marginBottom = 10;
        layout.fill = true;
        return layout;
    }
}

