/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.preferences.fwk;

import com.wuetherich.osgi.ds.annotations.DsAnnotationsCore;
import com.wuetherich.osgi.ds.annotations.internal.preferences.fwk.ConfigurationBlock;
import com.wuetherich.osgi.ds.annotations.internal.preferences.fwk.DialogField;
import com.wuetherich.osgi.ds.annotations.internal.preferences.fwk.IDialogFieldListener;
import com.wuetherich.osgi.ds.annotations.internal.preferences.fwk.ProjectSelectionDialog;
import com.wuetherich.osgi.ds.annotations.internal.preferences.fwk.SelectionButtonDialogField;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractPropertyAndPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private Composite _parentComposite;
    private Link _changeSettings;
    private SelectionButtonDialogField _useProjectSettings;
    private ConfigurationBlock _configurationBlock;
    private ControlEnableState _blockEnableState;
    private IProject _project;
    private Map<String, Object> _pageData;
    public static final String DATA_NO_LINK = "AbstractPropertyAndPreferencesPage.nolink";

    public boolean performOk() {
        if (this._configurationBlock != null && !this._configurationBlock.performOk()) {
            return false;
        }
        this.savePreferences();
        return true;
    }

    protected void performApply() {
        if (this._configurationBlock != null && !this._configurationBlock.performApply()) {
            return;
        }
        this.savePreferences();
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this._configurationBlock != null) {
            if (this.isProjectPreferencePage()) {
                try {
                    IEclipsePreferences eclipsePreferences = InstanceScope.INSTANCE.getNode(this.getStoreIdentifier());
                    String[] stringArray = eclipsePreferences.keys();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        this.getPreferenceStore().setDefault(key, eclipsePreferences.get(key, null));
                        ++n2;
                    }
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
            }
            this._configurationBlock.performDefaults();
        }
    }

    public boolean performCancel() {
        if (this._configurationBlock != null && !this._configurationBlock.performCancel()) {
            return false;
        }
        return super.performCancel();
    }

    public void performHelp() {
        this._configurationBlock.performHelp();
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        return project != null && this._configurationBlock != null && this._configurationBlock.hasProjectSpecificOptions(project);
    }

    public abstract String getStoreIdentifier();

    protected abstract String getPreferencePageID();

    protected abstract String getPropertyPageID();

    protected abstract ConfigurationBlock createPreferenceContent(Composite var1);

    public IAdaptable getElement() {
        return this._project;
    }

    public void setElement(IAdaptable element) {
        this._project = (IProject)element.getAdapter(IResource.class);
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            this._pageData = (Map)data;
        }
        if (this._changeSettings != null && !this.offerLink()) {
            this._changeSettings.dispose();
            this._parentComposite.layout(true, true);
        }
    }

    protected Map<String, Object> getData() {
        return this._pageData;
    }

    public boolean isProjectPreferencePage() {
        return this._project != null;
    }

    protected boolean supportsProjectSpecificOptions() {
        return this.getPropertyPageID() != null;
    }

    public IProject getProject() {
        return this._project;
    }

    protected final void openWorkspacePreferences(Object data) {
        String id = this.getPreferencePageID();
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)data).open();
    }

    protected final void openProjectProperties(IProject project, Object data) {
        String id = this.getPropertyPageID();
        if (id != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project, (String)id, (String[])new String[]{id}, (Object)data).open();
        }
    }

    protected boolean offerLink() {
        return this._pageData == null || !Boolean.TRUE.equals(this._pageData.get(DATA_NO_LINK));
    }

    protected Label createDescriptionLabel(Composite parent) {
        this._parentComposite = parent;
        if (this.isProjectPreferencePage()) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            IDialogFieldListener listener = new IDialogFieldListener(){

                @Override
                public void dialogFieldChanged(DialogField field) {
                    boolean enabled = ((SelectionButtonDialogField)field).isSelected();
                    AbstractPropertyAndPreferencesPage.this.enableProjectSpecificSettings(enabled);
                    if (enabled && AbstractPropertyAndPreferencesPage.this.getData() != null) {
                        AbstractPropertyAndPreferencesPage.this.applyData(AbstractPropertyAndPreferencesPage.this.getData());
                    }
                }
            };
            this._useProjectSettings = new SelectionButtonDialogField(32);
            this._useProjectSettings.setDialogFieldListener(listener);
            this._useProjectSettings.setLabelText("Enable project specific settings");
            this._useProjectSettings.doFillIntoGrid(composite, 1);
            if (this.offerLink()) {
                this._changeSettings = this.createLink(composite, "Configure Workspace Settings...");
                this._changeSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            }
            Label horizontalLine = new Label(composite, 258);
            horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            horizontalLine.setFont(composite.getFont());
        } else if (this.supportsProjectSpecificOptions() && this.offerLink()) {
            this._changeSettings = this.createLink(parent, "Configure Project Specific Settings...");
            this._changeSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        }
        return super.createDescriptionLabel(parent);
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        this._useProjectSettings.setSelection(useProjectSpecificSettings);
        this.enablePreferenceContent(useProjectSpecificSettings);
        this.updateLinkVisibility();
    }

    protected void enablePreferenceContent(boolean enable) {
        if (enable) {
            if (this._blockEnableState != null) {
                this._blockEnableState.restore();
                this._blockEnableState = null;
            }
        } else if (this._blockEnableState == null) {
            this._blockEnableState = ControlEnableState.disable((Control)this._configurationBlock);
        }
    }

    public ConfigurationBlock getConfigurationBlock() {
        return this._configurationBlock;
    }

    private void updateLinkVisibility() {
        if (this._changeSettings == null || this._changeSettings.isDisposed()) {
            return;
        }
        if (this.isProjectPreferencePage()) {
            this._changeSettings.setEnabled(!this.useProjectSettings());
        }
    }

    public boolean useProjectSettings() {
        return this.isProjectPreferencePage() && this._useProjectSettings != null && this._useProjectSettings.isSelected();
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPropertyAndPreferencesPage.this.doLinkActivated((Link)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractPropertyAndPreferencesPage.this.doLinkActivated((Link)e.widget);
            }
        });
        return link;
    }

    final void doLinkActivated(Link link) {
        Map<String, Object> data = this.getData();
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        data.put(DATA_NO_LINK, Boolean.TRUE);
        if (this.isProjectPreferencePage()) {
            this.openWorkspacePreferences(data);
        } else {
            DsAnnotationsCore.getDsAnnotationAwareProjects();
            HashSet<IProject> projectsWithSpecifics = new HashSet<IProject>();
            for (IProject project : DsAnnotationsCore.getDsAnnotationAwareProjects()) {
                if (!this.hasProjectSpecificOptions(project)) continue;
                projectsWithSpecifics.add(project);
            }
            ProjectSelectionDialog dialog = new ProjectSelectionDialog(this.getShell(), projectsWithSpecifics);
            if (dialog.open() == 0) {
                IProject result = (IProject)dialog.getFirstResult();
                this.openProjectProperties(result, data);
            }
        }
    }

    public IEclipsePreferences getPreferenceStoreAsEclipsePreferences() {
        IEclipsePreferences[] eclipsePreferences = ((ScopedPreferenceStore)this.getPreferenceStore()).getPreferenceNodes(false);
        return eclipsePreferences[0];
    }

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        if (this.isProjectPreferencePage()) {
            return new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.getProject()), this.getStoreIdentifier());
        }
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, this.getStoreIdentifier());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        GridData data = new GridData(4, 1, true, true);
        this._configurationBlock = this.createPreferenceContent(composite);
        this._configurationBlock.setLayoutData(data);
        this._configurationBlock.initialize();
        if (this.isProjectPreferencePage()) {
            boolean useProjectSettings = this.hasProjectSpecificOptions(this.getProject());
            this.enableProjectSpecificSettings(useProjectSettings);
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void savePreferences() {
        try {
            if (this.isProjectPreferencePage() && !this.useProjectSettings()) {
                String[] stringArray = this._configurationBlock.getPreferenceKeys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    this.getPreferenceStoreAsEclipsePreferences().remove(key);
                    ++n2;
                }
            }
            ScopedPreferenceStore scopedPreferenceStore = (ScopedPreferenceStore)this.getPreferenceStore();
            scopedPreferenceStore.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int convertHeightInCharsToPixels(int chars) {
        return super.convertHeightInCharsToPixels(chars);
    }

    public int convertHorizontalDLUsToPixels(int dlus) {
        return super.convertHorizontalDLUsToPixels(dlus);
    }

    public int convertVerticalDLUsToPixels(int dlus) {
        return super.convertVerticalDLUsToPixels(dlus);
    }

    public int convertWidthInCharsToPixels(int chars) {
        return super.convertWidthInCharsToPixels(chars);
    }
}

