/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.builder;

import com.wuetherich.osgi.ds.annotations.internal.DsAnnotationProblem;
import com.wuetherich.osgi.ds.annotations.internal.builder.ComponentDescription;
import com.wuetherich.osgi.ds.annotations.internal.builder.ComponentDescriptionWriter;
import com.wuetherich.osgi.ds.annotations.internal.builder.DsAnnotationAstVisitor;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class DsAnnotationBuildVisitor
implements IResourceVisitor,
IResourceDeltaVisitor {
    public boolean visit(IResource resource) throws CoreException {
        if (resource.getType() != 1) {
            return true;
        }
        this.handle(resource);
        return false;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta.getKind() == 1) {
            return this.visit(delta.getResource());
        }
        if (delta.getKind() == 2) {
            ComponentDescriptionWriter.deleteGeneratedFiles(delta.getResource().getProject(), delta.getResource().getProjectRelativePath());
        } else if (delta.getKind() == 4) {
            return this.visit(delta.getResource());
        }
        return true;
    }

    private void handle(IResource resource) throws CoreException {
        if (!resource.getName().endsWith(".java")) {
            return;
        }
        IJavaElement element = JavaCore.create((IResource)resource);
        IJavaProject javaProject = JavaCore.create((IProject)resource.getProject());
        if (!javaProject.isOnClasspath(element) || !element.isStructureKnown()) {
            return;
        }
        if (JavaCore.create((IResource)resource) == null) {
            return;
        }
        try {
            resource.deleteMarkers("com.wuetherich.osgi.ds.annotations.dsAnnotationProblem", true, 0);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        if (element != null && element.isStructureKnown()) {
            this.parse((ICompilationUnit)element, resource);
        }
    }

    private void parse(ICompilationUnit icompilationUnit, IResource resource) throws CoreException {
        CompilationUnit result = this.createAst(icompilationUnit);
        DsAnnotationAstVisitor myAstVisitor = new DsAnnotationAstVisitor();
        result.accept((ASTVisitor)myAstVisitor);
        if (myAstVisitor.getComponentDescriptions().isEmpty() && myAstVisitor.hasTypes()) {
            ComponentDescriptionWriter.deleteGeneratedFiles(resource.getProject(), resource.getFullPath());
        }
        for (ComponentDescription description : myAstVisitor.getComponentDescriptions()) {
            if (description.hasProblems()) {
                try {
                    for (DsAnnotationProblem problem : description.getProblems()) {
                        IMarker marker = resource.createMarker("com.wuetherich.osgi.ds.annotations.dsAnnotationProblem");
                        marker.setAttribute("severity", 2);
                        marker.setAttribute("charStart", problem.getCharStart());
                        marker.setAttribute("charEnd", problem.getCharEnd());
                        marker.setAttribute("message", (Object)problem.getMessage());
                    }
                }
                catch (CoreException e) {
                    ComponentDescriptionWriter.deleteGeneratedFiles(resource.getProject(), resource.getFullPath());
                    e.printStackTrace();
                }
                continue;
            }
            ComponentDescriptionWriter.writeComponentDescription(resource.getProject(), description);
        }
    }

    private CompilationUnit createAst(ICompilationUnit icompilationUnit) {
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setSource(icompilationUnit);
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)"1.7", (Map)options);
        parser.setCompilerOptions((Map)options);
        parser.setResolveBindings(true);
        CompilationUnit result = (CompilationUnit)parser.createAST(null);
        return result;
    }
}

