/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.builder;

import com.wuetherich.osgi.ds.annotations.internal.Activator;
import com.wuetherich.osgi.ds.annotations.internal.util.PathUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.project.IBundleProjectDescription;

public class ManifestAndBuildPropertiesUpdater {
    public static void updateManifestAndBuildProperties(IProject project, Map<IPath, List<IPath>> map) throws CoreException {
        boolean projectDescriptionChanged = false;
        IBundleProjectDescription bundleProjectDescription = Activator.getBundleProjectDescription(project);
        if (bundleProjectDescription != null) {
            if (map.size() > 0) {
                LinkedList<String> descriptions = new LinkedList<String>();
                for (List<IPath> pathes : map.values()) {
                    for (IPath iPath : pathes) {
                        descriptions.add(iPath.toPortableString());
                    }
                }
                StringBuilder stringBuilder = new StringBuilder();
                Iterator iterator = descriptions.iterator();
                while (iterator.hasNext()) {
                    stringBuilder.append((String)iterator.next());
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(",\n ");
                }
                String newHeader = stringBuilder.toString();
                projectDescriptionChanged = !(newHeader = newHeader.replace(",\n ", ",")).equals(bundleProjectDescription.getHeader("Service-Component"));
                bundleProjectDescription.setHeader("Service-Component", stringBuilder.toString());
            } else {
                projectDescriptionChanged = bundleProjectDescription.getHeader("Service-Component") == null;
                bundleProjectDescription.setHeader("Service-Component", null);
            }
            boolean changedBuildProperties = ManifestAndBuildPropertiesUpdater.addComponentDescriptionFolderToBinIncludes(map, bundleProjectDescription);
            boolean bl = projectDescriptionChanged = projectDescriptionChanged || changedBuildProperties;
            if (projectDescriptionChanged) {
                String[] stringArray = ManifestAndBuildPropertiesUpdater.getManifestEmptyHeader(project);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String emtptyHeader = stringArray[n2];
                    bundleProjectDescription.setHeader(emtptyHeader, "");
                    ++n2;
                }
                bundleProjectDescription.apply(null);
            }
        }
    }

    private static boolean addComponentDescriptionFolderToBinIncludes(Map<IPath, List<IPath>> map, IBundleProjectDescription bundleProjectDescription) {
        Path componentDescriptionFolder = new Path("OSGI-INF/");
        Object[] binIncludePaths = bundleProjectDescription.getBinIncludes();
        if (!PathUtils.contains((IPath[])binIncludePaths, (IPath)componentDescriptionFolder) && map.size() > 0) {
            if (binIncludePaths != null) {
                IPath[] newPaths = new IPath[binIncludePaths.length + 1];
                System.arraycopy(binIncludePaths, 0, newPaths, 0, binIncludePaths.length);
                newPaths[binIncludePaths.length] = componentDescriptionFolder;
                binIncludePaths = newPaths;
            } else {
                binIncludePaths = new IPath[]{componentDescriptionFolder};
            }
        } else if (PathUtils.contains((IPath[])binIncludePaths, (IPath)componentDescriptionFolder) && map.size() == 0) {
            LinkedList<Object> newPathList = new LinkedList<Object>();
            Object[] objectArray = binIncludePaths;
            int n = binIncludePaths.length;
            int n2 = 0;
            while (n2 < n) {
                Object binIncludePath = objectArray[n2];
                if (!binIncludePath.equals((Object)componentDescriptionFolder)) {
                    newPathList.add(binIncludePath);
                }
                ++n2;
            }
            binIncludePaths = newPathList.toArray(new IPath[0]);
        }
        boolean result = !Arrays.deepEquals(bundleProjectDescription.getBinIncludes(), binIncludePaths);
        bundleProjectDescription.setBinIncludes((IPath[])binIncludePaths);
        return result;
    }

    private static String[] getManifestEmptyHeader(IProject project) {
        try {
            IFile file = project.getFile("META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(file.getContents());
            LinkedList<String> result = new LinkedList<String>();
            for (Map.Entry<Object, Object> entries : manifest.getMainAttributes().entrySet()) {
                if (entries.getValue() != null && !entries.getValue().toString().isEmpty()) continue;
                result.add(entries.getKey().toString());
            }
            return result.toArray(new String[0]);
        }
        catch (Throwable throwable) {
            return new String[0];
        }
    }
}

