/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.builder;

import com.wuetherich.osgi.ds.annotations.internal.builder.ComponentDescription;
import com.wuetherich.osgi.ds.annotations.internal.builder.ManifestAndBuildPropertiesUpdater;
import com.wuetherich.osgi.ds.annotations.internal.util.GenericCache;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ComponentDescriptionWriter {
    private static Pattern REGEXP_PATTERN = Pattern.compile("(Generated by DS Annotation Builder \\[)(.*)(\\])");
    private static final boolean MARK_GENERATED_COMPONENT_DESCRIPTIONS_AS_DERIVED = false;

    public static void removeDanglingComponentDescriptions(IProject project) {
        for (Map.Entry<IPath, List<IPath>> entry : ComponentDescriptionWriter.loadProperties(project).entrySet()) {
            try {
                IFile originFile = project.getFile(entry.getKey());
                if (originFile.exists()) continue;
                for (IPath path : entry.getValue()) {
                    try {
                        project.getFile(path).delete(true, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            ManifestAndBuildPropertiesUpdater.updateManifestAndBuildProperties(project, ComponentDescriptionWriter.loadProperties(project));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void writeComponentDescription(IProject project, ComponentDescription description) throws CoreException {
        IFile file = project.getFile(new Path("OSGI-INF").append((IPath)new Path(String.valueOf(description.getName()) + ".xml")));
        try {
            if (file.exists() && description.equals(file.getContents(true)) && ComponentDescriptionWriter.containsDsAnnotationBuilderComment(file)) {
                return;
            }
        }
        catch (JAXBException jAXBException) {}
        IFolder folder = project.getFolder("OSGI-INF");
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        if (file.exists()) {
            file.setContents((InputStream)new StringBufferInputStream(description.toXml()), 1, null);
        } else {
            file.create((InputStream)new StringBufferInputStream(description.toXml()), true, null);
        }
        folder.refreshLocal(2, null);
        ManifestAndBuildPropertiesUpdater.updateManifestAndBuildProperties(project, ComponentDescriptionWriter.loadProperties(project));
    }

    public static void deleteGeneratedFiles(IProject project, IPath resource) throws CoreException {
        Map<IPath, List<IPath>> generatedFiles = ComponentDescriptionWriter.loadProperties(project);
        List<IPath> result = generatedFiles.get(resource);
        if (result != null) {
            for (IPath path : result) {
                try {
                    IFile file = project.getFile(path);
                    file.delete(true, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        ManifestAndBuildPropertiesUpdater.updateManifestAndBuildProperties(project, ComponentDescriptionWriter.loadProperties(project));
    }

    private static Map<IPath, List<IPath>> loadProperties(IProject project) {
        Assert.isNotNull((Object)project);
        IFolder folder = project.getFolder("OSGI-INF");
        try {
            if (folder.exists()) {
                folder.refreshLocal(2, null);
            }
        }
        catch (CoreException coreException) {}
        GenericCache<IPath, List<IPath>> genericCache = new GenericCache<IPath, List<IPath>>(){

            @Override
            public List<IPath> create(IPath key) {
                return new LinkedList<IPath>();
            }
        };
        try {
            if (folder.exists()) {
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String source;
                    IResource iResource = iResourceArray[n2];
                    if (iResource instanceof IFile && iResource.getName().endsWith(".xml") && (source = ComponentDescriptionWriter.extractSource((IFile)iResource)) != null) {
                        ((List)genericCache.getOrCreate((IPath)new Path(source))).add(iResource.getProjectRelativePath());
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return genericCache;
    }

    private static boolean containsDsAnnotationBuilderComment(IFile file) {
        return ComponentDescriptionWriter.extractSource(file) != null;
    }

    private static String extractSource(IFile file) {
        String result = null;
        try {
            InputStream inputStream = file.getContents();
            XMLStreamReader xmlStreamReader = null;
            try {
                xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                while (xmlStreamReader.hasNext() && result == null) {
                    String comment;
                    Matcher matcher;
                    if (xmlStreamReader.next() != 5 || !(matcher = REGEXP_PATTERN.matcher(comment = xmlStreamReader.getText())).matches()) continue;
                    result = matcher.group(2);
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    xmlStreamReader.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                inputStream.close();
                xmlStreamReader.close();
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {}
        return result;
    }

    private static IPath findSourceFileForComponentDescriptionPath(IProject project, IPath path) {
        for (Map.Entry<IPath, List<IPath>> entry : ComponentDescriptionWriter.loadProperties(project).entrySet()) {
            for (IPath iPath : entry.getValue()) {
                if (!iPath.equals((Object)path)) continue;
                return entry.getKey();
            }
        }
        return null;
    }
}

