/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.builder;

import com.wuetherich.osgi.ds.annotations.internal.DsAnnotationException;
import com.wuetherich.osgi.ds.annotations.internal.DsAnnotationProblem;
import com.wuetherich.osgi.ds.annotations.internal.builder.ComponentDescription;
import com.wuetherich.osgi.ds.annotations.internal.builder.ComponentProperty;
import com.wuetherich.osgi.ds.annotations.internal.util.GenericCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

public class DsAnnotationAstVisitor
extends ASTVisitor {
    private Stack<TypeDeclaration> _currentTypeDeclaration;
    private MethodDeclaration _currentMethodDeclaration;
    private Map<TypeDeclaration, ComponentDescription> _descriptions = new HashMap<TypeDeclaration, ComponentDescription>();
    private boolean _hasTypes = false;

    public DsAnnotationAstVisitor() {
        this._currentTypeDeclaration = new Stack();
    }

    public Collection<ComponentDescription> getComponentDescriptions() {
        return this._descriptions.values();
    }

    public boolean hasTypes() {
        return this._hasTypes;
    }

    public boolean visit(TypeDeclaration node) {
        this._hasTypes = true;
        this._currentTypeDeclaration.push(node);
        return true;
    }

    public void endVisit(TypeDeclaration node) {
        this._currentTypeDeclaration.pop();
    }

    public boolean visit(MethodDeclaration node) {
        this._currentMethodDeclaration = node;
        return true;
    }

    public void endVisit(MethodDeclaration node) {
        this._currentMethodDeclaration = null;
    }

    public boolean visit(MarkerAnnotation node) {
        if (DsAnnotationAstVisitor.isDsAnnotation((Annotation)node)) {
            this.handleDsAnnotation((Annotation)node);
        }
        return this._currentMethodDeclaration == null;
    }

    public boolean visit(NormalAnnotation node) {
        if (DsAnnotationAstVisitor.isDsAnnotation((Annotation)node)) {
            this.handleDsAnnotation((Annotation)node);
        }
        return this._currentMethodDeclaration == null;
    }

    public boolean visit(SingleMemberAnnotation node) {
        if (DsAnnotationAstVisitor.isDsAnnotation((Annotation)node)) {
            this.handleDsAnnotation((Annotation)node);
        }
        return this._currentMethodDeclaration == null;
    }

    /*
     * Unable to fully structure code
     */
    private void handleDsAnnotation(Annotation node) {
        block20: {
            block21: {
                try {
                    if (!this._currentTypeDeclaration.isEmpty()) {
                        if (node.resolveTypeBinding().getQualifiedName().equals(Component.class.getName())) {
                            this._descriptions.put(this._currentTypeDeclaration.peek(), new ComponentDescription(this._currentTypeDeclaration.peek()));
                            this.getCurrentComponentDescription().setComponentDefaults();
                            if (node.isNormalAnnotation()) {
                                this.handleNormalComponentAnnotation((NormalAnnotation)node);
                            } else if (!node.isSingleMemberAnnotation()) {
                                node.isMarkerAnnotation();
                            }
                        }
                        if (this._currentMethodDeclaration != null) {
                            if (node.resolveTypeBinding().getQualifiedName().equals(Activate.class.getName())) {
                                this.getCurrentComponentDescription().setActivateMethod(this._currentMethodDeclaration.getName().getFullyQualifiedName());
                            } else if (node.resolveTypeBinding().getQualifiedName().equals(Deactivate.class.getName())) {
                                this.getCurrentComponentDescription().setDeactivateMethod(this._currentMethodDeclaration.getName().getFullyQualifiedName());
                            } else if (node.resolveTypeBinding().getQualifiedName().equals(Modified.class.getName())) {
                                this.getCurrentComponentDescription().setModifiedMethod(this._currentMethodDeclaration.getName().getFullyQualifiedName());
                            } else if (node.resolveTypeBinding().getQualifiedName().equals(Reference.class.getName())) {
                                if (node.isNormalAnnotation()) {
                                    this.handleNormalReferenceAnnotation((NormalAnnotation)node);
                                } else if (!node.isSingleMemberAnnotation() && node.isMarkerAnnotation()) {
                                    service = this._currentMethodDeclaration.resolveBinding().getParameterTypes()[0].getBinaryName();
                                    bind = this._currentMethodDeclaration.getName().getFullyQualifiedName();
                                    this.getCurrentComponentDescription().addReference(service, bind, null, null, null, null, null, null, null);
                                }
                            }
                        }
                    }
                    break block20;
                }
                catch (Exception e) {
                    astNode = node;
                    if (!(e instanceof DsAnnotationException) || !(annotationException = (DsAnnotationException)e).hasAnnotationField()) break block21;
                    astNode = node;
                    if (!(node instanceof NormalAnnotation)) break block21;
                    ** for (object : ((NormalAnnotation)node).values())
                }
lbl-1000:
                // 1 sources

                {
                    pair = (MemberValuePair)object;
                    valueName = pair.getName().toString();
                    if (!valueName.equals(annotationException.getAnnotationField())) continue;
                    astNode = pair;
                    break;
                }
            }
            if (this.getCurrentComponentDescription() != null) {
                this.getCurrentComponentDescription().getProblems().add(new DsAnnotationProblem(e.getMessage() != null ? e.getMessage() : "Unknown error in annotation", astNode.getStartPosition(), astNode.getStartPosition() + astNode.getLength()));
            }
        }
    }

    private void handleNormalReferenceAnnotation(NormalAnnotation normalAnnotation) {
        String name = null;
        String cardinality = null;
        String policy = null;
        String policyOption = null;
        String unbind = null;
        String updated = null;
        String target = null;
        String service = this._currentMethodDeclaration.resolveBinding().getParameterTypes()[0].getBinaryName();
        String bind = this._currentMethodDeclaration.getName().getFullyQualifiedName();
        for (Object object : normalAnnotation.values()) {
            IVariableBinding variableBinding;
            MemberValuePair pair = (MemberValuePair)object;
            String valueName = pair.getName().toString();
            if ("name".equals(valueName)) {
                name = pair.resolveMemberValuePairBinding().getValue().toString();
                continue;
            }
            if ("cardinality".equals(valueName)) {
                variableBinding = (IVariableBinding)pair.resolveMemberValuePairBinding().getValue();
                cardinality = variableBinding.getName().toLowerCase();
                continue;
            }
            if ("policy".equals(valueName)) {
                policy = ((IVariableBinding)pair.resolveMemberValuePairBinding().getValue()).getName();
                continue;
            }
            if ("policyOption".equals(valueName)) {
                variableBinding = (IVariableBinding)pair.resolveMemberValuePairBinding().getValue();
                policyOption = variableBinding.getName().toLowerCase();
                continue;
            }
            if ("service".equals(valueName)) {
                service = ((ITypeBinding)pair.resolveMemberValuePairBinding().getValue()).getBinaryName();
                continue;
            }
            if ("unbind".equals(valueName)) {
                unbind = pair.resolveMemberValuePairBinding().getValue().toString();
                continue;
            }
            if ("updated".equals(valueName)) {
                updated = pair.resolveMemberValuePairBinding().getValue().toString();
                continue;
            }
            if (!"target".equals(valueName)) continue;
            target = pair.resolveMemberValuePairBinding().getValue().toString();
        }
        this.getCurrentComponentDescription().addReference(service, bind, name, cardinality, policy, policyOption, unbind, updated, target);
    }

    private void handleNormalComponentAnnotation(NormalAnnotation normalAnnotation) {
        for (Object object : normalAnnotation.values()) {
            int n;
            MemberValuePair pair = (MemberValuePair)object;
            String valueName = pair.getName().toString();
            if ("name".equals(valueName)) {
                this.getCurrentComponentDescription().setName((String)pair.resolveMemberValuePairBinding().getValue());
                continue;
            }
            if ("enabled".equals(valueName)) {
                this.getCurrentComponentDescription().setEnabled((Boolean)pair.resolveMemberValuePairBinding().getValue());
                continue;
            }
            if ("immediate".equals(valueName)) {
                this.getCurrentComponentDescription().setImmediate((Boolean)pair.resolveMemberValuePairBinding().getValue());
                continue;
            }
            if ("factory".equals(valueName)) {
                this.getCurrentComponentDescription().setFactory((String)pair.resolveMemberValuePairBinding().getValue());
                continue;
            }
            if ("configurationPolicy".equals(valueName)) {
                IVariableBinding variableBinding = (IVariableBinding)pair.resolveMemberValuePairBinding().getValue();
                this.getCurrentComponentDescription().setConfigurationPolicy(variableBinding.getName().toLowerCase());
                continue;
            }
            if ("property".equals(valueName)) {
                GenericCache<String, List<ComponentProperty>> properties = new GenericCache<String, List<ComponentProperty>>(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected List<ComponentProperty> create(String key) {
                        return new LinkedList<ComponentProperty>();
                    }
                };
                Object[] objectArray = (Object[])pair.resolveMemberValuePairBinding().getValue();
                n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object keyValue = objectArray[n2];
                    String[] strings = ((String)keyValue).split("=");
                    String[] nameTypePair = strings[0].split(":");
                    ComponentProperty componentProperty = new ComponentProperty();
                    if (nameTypePair.length > 1) {
                        ((List)properties.getOrCreate(nameTypePair[0])).add(componentProperty);
                        componentProperty.setName(nameTypePair[0]);
                        componentProperty.setType(nameTypePair[1]);
                    } else {
                        ((List)properties.getOrCreate(strings[0])).add(componentProperty);
                        componentProperty.setName(strings[0]);
                    }
                    componentProperty.setValue(strings[1]);
                    ++n2;
                }
                this.getCurrentComponentDescription().addProperty((Map<String, List<ComponentProperty>>)properties);
                continue;
            }
            if ("properties".equals(valueName)) {
                Object[] objectArray = (Object[])pair.resolveMemberValuePairBinding().getValue();
                int n3 = objectArray.length;
                int keyValue = 0;
                while (keyValue < n3) {
                    Object keyValue2 = objectArray[keyValue];
                    this.getCurrentComponentDescription().addProperties((String)keyValue2);
                    ++keyValue;
                }
                continue;
            }
            if ("service".equals(valueName)) {
                Object[] objects = (Object[])pair.resolveMemberValuePairBinding().getValue();
                LinkedList<String> services = new LinkedList<String>();
                Object[] objectArray = objects;
                int n4 = objects.length;
                n = 0;
                while (n < n4) {
                    Object tb = objectArray[n];
                    ITypeBinding typeBinding = (ITypeBinding)tb;
                    services.add(typeBinding.getBinaryName());
                    ++n;
                }
                this.getCurrentComponentDescription().setService(services.toArray(new String[0]));
                continue;
            }
            if (!"servicefactory".equals(valueName)) continue;
            this.getCurrentComponentDescription().setServiceFactory((Boolean)pair.resolveMemberValuePairBinding().getValue());
        }
    }

    public static boolean isDsAnnotation(Annotation annotation) {
        ITypeBinding typeBinding = annotation.resolveTypeBinding();
        if (typeBinding != null) {
            return Component.class.getPackage().getName().equals(annotation.resolveTypeBinding().getPackage().getName());
        }
        return false;
    }

    private ComponentDescription getCurrentComponentDescription() {
        return this._descriptions.get(this._currentTypeDeclaration.peek());
    }
}

