/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.builder;

import com.wuetherich.osgi.ds.annotations.DsAnnotationVersion;
import com.wuetherich.osgi.ds.annotations.internal.DsAnnotationException;
import com.wuetherich.osgi.ds.annotations.internal.builder.AbstractDsAnnotationAstVisitor;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;

public class DetectDsAnnotationVersionAstVisitor
extends AbstractDsAnnotationAstVisitor {
    private DsAnnotationVersion _xmlns = DsAnnotationVersion.V_1_0;
    private DsAnnotationVersion _specifiedXmlns;
    private DsAnnotationException _annotationException;

    public DetectDsAnnotationVersionAstVisitor(IProject project) {
        super(project);
    }

    public DsAnnotationVersion getDsAnnotationVersion() {
        return this._xmlns;
    }

    public DsAnnotationException getAnnotationException() {
        return this._annotationException;
    }

    public DsAnnotationVersion getSpecifiedXmlns() {
        return this._specifiedXmlns;
    }

    public boolean hasSpecifiedXmlns() {
        return this._specifiedXmlns != null;
    }

    public boolean hasAnnotationException() {
        return this._annotationException != null;
    }

    public DsAnnotationVersion getEffectiveVersion() {
        return this._specifiedXmlns != null ? this._specifiedXmlns : this._xmlns;
    }

    @Override
    protected void handleComponentAnnotation(MarkerAnnotation node) {
    }

    @Override
    protected void handleComponentAnnotation(NormalAnnotation node) {
        for (Object object : node.values()) {
            MemberValuePair pair = (MemberValuePair)object;
            if ("xmlns".equals(pair.getName().toString())) {
                String xmlns = (String)pair.resolveMemberValuePairBinding().getValue();
                this._specifiedXmlns = DsAnnotationVersion.getFromNamespace(xmlns);
                if (this._specifiedXmlns != null) continue;
                this._annotationException = new DsAnnotationException(String.format("Invalid namespace definition '%s'.", xmlns));
                continue;
            }
            if ("configurationPid".equals(pair.getName().toString())) {
                this.setUpTo(DsAnnotationVersion.V_1_2);
                continue;
            }
            if (!"configurationPolicy".equals(pair.getName().toString())) continue;
            this.setUpTo(DsAnnotationVersion.V_1_1);
        }
    }

    @Override
    protected void handleReferenceAnnotation(MarkerAnnotation node) {
        this.checkReferenceForUpdateMethod();
    }

    @Override
    protected void handleReferenceAnnotation(NormalAnnotation node) {
        for (Object object : node.values()) {
            MemberValuePair pair = (MemberValuePair)object;
            String valueName = pair.getName().toString();
            if ("updated".equals(valueName)) {
                this.setUpTo(DsAnnotationVersion.V_1_2);
                return;
            }
            if (!"policyOption".equals(valueName)) continue;
            this.setUpTo(DsAnnotationVersion.V_1_2);
            return;
        }
        this.checkReferenceForUpdateMethod();
    }

    @Override
    protected void handleModifiedAnnotation(MarkerAnnotation node) {
        this.setUpTo(DsAnnotationVersion.V_1_1);
    }

    @Override
    protected void handleDeactivateAnnotation(MarkerAnnotation node) {
        this.setUpTo(DsAnnotationVersion.V_1_1);
    }

    @Override
    protected void handleActivateAnnotation(MarkerAnnotation node) {
        this.setUpTo(DsAnnotationVersion.V_1_1);
    }

    @Override
    protected void handleException(ASTNode node, Exception e) {
    }

    private void setUpTo(DsAnnotationVersion version) {
        if (version.greaterThan(this._xmlns)) {
            this._xmlns = version;
        }
    }

    private void checkReferenceForUpdateMethod() {
        String methodName = this.getCurrentMethodDeclaration().getName().getFullyQualifiedName();
        String updatedMethodName = DetectDsAnnotationVersionAstVisitor.computeUpdatedMethodName(methodName);
        MethodDeclaration[] methodDeclarationArray = this.getCurrentTypeDeclarationStack().peek().getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            if (updatedMethodName.equals(methodDeclaration.getName().getFullyQualifiedName())) {
                this.setUpTo(DsAnnotationVersion.V_1_2);
            }
            ++n2;
        }
    }
}

