/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.componentdescription.impl;

import com.wuetherich.osgi.ds.annotations.internal.DsAnnotationException;
import com.wuetherich.osgi.ds.annotations.internal.DsAnnotationProblem;
import com.wuetherich.osgi.ds.annotations.internal.builder.ComponentProperty;
import com.wuetherich.osgi.ds.annotations.internal.componentdescription.AbstractTypeAccessor;
import com.wuetherich.osgi.ds.annotations.internal.componentdescription.IComponentDescription;
import com.wuetherich.osgi.ds.annotations.internal.componentdescription.Reference;
import com.wuetherich.osgi.ds.annotations.internal.componentdescription.impl.Messages;
import com.wuetherich.osgi.ds.annotations.internal.util.GenericCache;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;

public abstract class AbstractComponentDescription
implements IComponentDescription {
    protected static final String FIELD_NAME_SERVICE = "service";
    protected static final String FIELD_NAME_SERVICEFACTORY = "servicefactory";
    protected static final String FIELD_NAME_TARGET = "target";
    private AbstractTypeAccessor _typeAccessor;

    public AbstractComponentDescription(AbstractTypeAccessor typeAccessor) {
        Assert.isNotNull((Object)typeAccessor);
        this._typeAccessor = typeAccessor;
    }

    public void execute() {
        int n;
        int n2;
        Object[] objectArray;
        if (this._typeAccessor.getDeactivateMethodName() != null && this._typeAccessor.getDeactivateMethodName().equals(this._typeAccessor.getActivateMethodName())) {
            throw new DsAnnotationException(String.format("Activate and deactivate method have the same name '%s'.", this._typeAccessor.getActivateMethodName()));
        }
        if (this._typeAccessor.getService() != null) {
            objectArray = this._typeAccessor.getService();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                String service = objectArray[n];
                Assert.isNotNull((Object)service);
                if (!this._typeAccessor.isInstanceOf(service)) {
                    throw new DsAnnotationException(String.format(Messages.ComponentDescription_INVALID_SERVICE_TYPE, service, FIELD_NAME_SERVICE));
                }
                ++n;
            }
        }
        if (this._typeAccessor.getService() == null && this.getTypeAccessor().getAllDirectlyImplementedSuperInterfaces().isEmpty() && this._typeAccessor.getServiceFactory() != null) {
            throw new DsAnnotationException(String.format(Messages.ComponentDescription_INVALID_SERVICEFACTORY_DECLARATION, FIELD_NAME_SERVICEFACTORY));
        }
        this.onSetName(this._typeAccessor.getName() != null ? this._typeAccessor.getName() : this._typeAccessor.getImplementationClassName());
        if (this._typeAccessor.isEnabled() != null) {
            this.onSetEnabled(this._typeAccessor.isEnabled());
        }
        if (this._typeAccessor.isImmediate() != null) {
            this.onSetImmediate(this._typeAccessor.isImmediate());
        }
        if (this._typeAccessor.getFactory() != null) {
            this.onSetFactory(this._typeAccessor.getFactory());
        }
        if (this._typeAccessor.getServiceFactory() != null) {
            this.onSetServiceFactory(this._typeAccessor.getServiceFactory());
        }
        this.onSetService(this._typeAccessor.getService() != null ? this._typeAccessor.getService() : this.getTypeAccessor().getAllDirectlyImplementedSuperInterfaces().toArray(new String[0]));
        if (this._typeAccessor.getConfigurationPid() != null) {
            this.onSetConfigurationPid(this._typeAccessor.getConfigurationPid());
        }
        if (this._typeAccessor.getConfigurationPolicy() != null) {
            this.onSetConfigurationPolicy(this._typeAccessor.getConfigurationPolicy());
        }
        if (this._typeAccessor.getActivateMethodName() != null) {
            this.onSetActivate(this._typeAccessor.getActivateMethodName());
        }
        if (this._typeAccessor.getDeactivateMethodName() != null) {
            this.onSetDeactivate(this._typeAccessor.getDeactivateMethodName());
        }
        if (this._typeAccessor.getModifiedMethodName() != null) {
            this.onSetModified(this._typeAccessor.getModifiedMethodName());
        }
        if (this._typeAccessor.getProperty() != null) {
            this.processPropertyAttribute(this._typeAccessor.getProperty());
        }
        if (this._typeAccessor.getProperties() != null) {
            objectArray = this._typeAccessor.getProperties();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object keyValue = objectArray[n];
                this.onAddProperties((String)keyValue);
                ++n;
            }
        }
        for (Reference ref : this._typeAccessor.getReferences()) {
            this.onAddReference(ref.getService(), ref.getBind(), ref.getName(), ref.getCardinality(), ref.getPolicy(), ref.getPolicyOption(), ref.getUnbind(), ref.getUpdated(), ref.getTarget());
        }
    }

    @Override
    public AbstractTypeAccessor getTypeAccessor() {
        return this._typeAccessor;
    }

    @Override
    public String getAssociatedSourceFile() {
        return this._typeAccessor.getAssociatedSourceFile();
    }

    @Override
    public final boolean hasProblems() {
        return this._typeAccessor.hasProblems();
    }

    @Override
    public final List<DsAnnotationProblem> getProblems() {
        return this._typeAccessor.getProblems();
    }

    public abstract void onSetActivate(String var1);

    public abstract void onSetModified(String var1);

    public abstract void onSetDeactivate(String var1);

    public abstract void onSetName(String var1);

    public abstract void onSetEnabled(Boolean var1);

    public abstract void onSetImmediate(Boolean var1);

    public abstract void onSetFactory(String var1);

    public abstract void onAddProperties(String var1);

    public abstract void onAddProperty(Map<String, List<ComponentProperty>> var1);

    public abstract void onSetConfigurationPolicy(String var1);

    public abstract void onSetConfigurationPid(String var1);

    public abstract void onSetServiceFactory(Boolean var1);

    public abstract void onSetService(String[] var1);

    public abstract void onAddReference(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9);

    protected boolean isNotEmpty(String name) {
        return name != null && name.trim().length() > 0;
    }

    private void processPropertyAttribute(Object[] propertyArray) {
        GenericCache<String, List<ComponentProperty>> propertyMap = new GenericCache<String, List<ComponentProperty>>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<ComponentProperty> create(String key) {
                return new LinkedList<ComponentProperty>();
            }
        };
        Object[] objectArray = propertyArray;
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object keyValue = objectArray[n2];
            String[] strings = ((String)keyValue).split("=");
            if (strings.length < 2) {
                throw new DsAnnotationException(String.format("Invalid property definition '%s'. Property definitions must follow the following syntax: name ( : type )? = value. ", (String)keyValue));
            }
            String[] nameTypePair = strings[0].split(":");
            ComponentProperty componentProperty = new ComponentProperty();
            if (nameTypePair.length > 1) {
                ((List)propertyMap.getOrCreate(nameTypePair[0])).add(componentProperty);
                componentProperty.setName(nameTypePair[0]);
                componentProperty.setType(nameTypePair[1]);
            } else {
                ((List)propertyMap.getOrCreate(strings[0])).add(componentProperty);
                componentProperty.setName(strings[0]);
            }
            componentProperty.setValue(strings[1]);
            ++n2;
        }
        this.onAddProperty((Map<String, List<ComponentProperty>>)propertyMap);
    }
}

