/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations;

public enum DsAnnotationVersion {
    V_1_0("http://www.osgi.org/xmlns/scr/v1.0.0", "1.0 (OSGi Release 4.0/4.1)"),
    V_1_1("http://www.osgi.org/xmlns/scr/v1.1.0", "1.1 (OSGi Release 4.2)"),
    V_1_2("http://www.osgi.org/xmlns/scr/v1.2.0", "1.2 (OSGi Release 4.3/5.0)"),
    V_1_3("http://www.osgi.org/xmlns/scr/v1.3.0", "1.3 (OSGi Release 6.0)");

    private String _xmlns;
    private String _description;

    private DsAnnotationVersion(String xmlns, String description) {
        this._xmlns = xmlns;
        this._description = description;
    }

    public String getXmlns() {
        return this._xmlns;
    }

    public String getDescription() {
        return this._description;
    }

    public boolean greaterThan(DsAnnotationVersion other) {
        return this.getXmlns().compareTo(other.getXmlns()) > 0;
    }

    public static DsAnnotationVersion getFromNamespace(String namespace) {
        DsAnnotationVersion[] dsAnnotationVersionArray = DsAnnotationVersion.values();
        int n = dsAnnotationVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            DsAnnotationVersion version = dsAnnotationVersionArray[n2];
            if (version.getXmlns().equals(namespace)) {
                return version;
            }
            ++n2;
        }
        return null;
    }
}

