/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal;

import com.wuetherich.osgi.ds.annotations.Constants;
import com.wuetherich.osgi.ds.annotations.internal.Activator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.project.IBundleProjectDescription;

public class DsAnnotationNature
implements IProjectNature {
    private IProject _project;

    public IProject getProject() {
        return this._project;
    }

    public void setProject(IProject value) {
        this._project = value;
    }

    public void configure() throws CoreException {
        IProjectDescription desc = this._project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(Constants.BUILDER_ID)) {
                return;
            }
            ++i;
        }
        ICommand command = desc.newCommand();
        command.setBuilderName(Constants.BUILDER_ID);
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 1, commands.length);
        newCommands[0] = command;
        desc.setBuildSpec(newCommands);
        this._project.setDescription(desc, null);
        this.configureDefaultImport();
    }

    public void deconfigure() throws CoreException {
        IProjectDescription desc = this._project.getDescription();
        LinkedList<ICommand> iCommands = new LinkedList<ICommand>(Arrays.asList(desc.getBuildSpec()));
        Iterator iterator = iCommands.iterator();
        while (iterator.hasNext()) {
            if (!((ICommand)iterator.next()).getBuilderName().equals(Constants.BUILDER_ID)) continue;
            iterator.remove();
            break;
        }
        desc.setBuildSpec(iCommands.toArray(new ICommand[0]));
        this._project.setDescription(desc, null);
    }

    private void configureDefaultImport() throws CoreException {
        IBundleProjectDescription bundleProjectDescription = Activator.getBundleProjectDescription(this._project);
        if (bundleProjectDescription != null) {
            String importPackage = bundleProjectDescription.getHeader("Import-Package");
            if (importPackage != null) {
                String[] stringArray = importPackage.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String imp = stringArray[n2];
                    String[] strings = imp.split(";");
                    if (strings[0].equals(Constants.DS_ANNOTATION_PACKAGE)) {
                        return;
                    }
                    ++n2;
                }
                bundleProjectDescription.setHeader("Import-Package", String.valueOf(importPackage) + ", " + Constants.DS_ANNOTATION_PACKAGE);
                bundleProjectDescription.apply(null);
            } else {
                bundleProjectDescription.setHeader("Import-Package", Constants.DS_ANNOTATION_PACKAGE);
                bundleProjectDescription.apply(null);
            }
        }
    }
}

