/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.componentdescription.impl;

import com.wuetherich.osgi.ds.annotations.internal.util.Cache;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ComponentDescriptionReader {
    private static Pattern REGEXP_PATTERN = Pattern.compile("(Generated by DS Annotation Builder \\[)(.*)(\\])");

    public Map<IPath, List<IPath>> loadGeneratedDescriptionsMap(IProject project) {
        Assert.isNotNull((Object)project);
        IFolder folder = project.getFolder("OSGI-INF");
        try {
            if (folder.exists()) {
                folder.refreshLocal(2, null);
            }
        }
        catch (CoreException coreException) {}
        Cache<IPath, List<IPath>> genericCache = new Cache<IPath, List<IPath>>(){
            private static final long serialVersionUID = 1L;

            @Override
            public List<IPath> create(IPath key) {
                return new LinkedList<IPath>();
            }
        };
        try {
            if (folder.exists()) {
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String source;
                    IResource iResource = iResourceArray[n2];
                    if (iResource instanceof IFile && iResource.getName().endsWith(".xml") && (source = this.extractSourceLocation((IFile)iResource)) != null) {
                        ((List)genericCache.getOrCreate((IPath)new Path(source))).add(iResource.getProjectRelativePath());
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return genericCache;
    }

    public List<IPath> getAllComponentDescriptions(IProject project) {
        Assert.isNotNull((Object)project);
        IFolder folder = project.getFolder("OSGI-INF");
        try {
            if (folder.exists()) {
                folder.refreshLocal(2, null);
            }
        }
        catch (CoreException coreException) {}
        LinkedList<IPath> result = new LinkedList<IPath>();
        try {
            if (folder.exists()) {
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource iResource = iResourceArray[n2];
                    if (iResource instanceof IFile && iResource.getName().endsWith(".xml") && this.isComponentDesciptor((IFile)iResource)) {
                        result.add(iResource.getProjectRelativePath());
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean containsDsAnnotationBuilderComment(IFile file) {
        return this.extractSourceLocation(file) != null;
    }

    public String extractSourceLocation(IFile file) {
        String result = null;
        try {
            InputStream inputStream = file.getContents();
            XMLStreamReader xmlStreamReader = null;
            try {
                xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
                while (xmlStreamReader.hasNext() && result == null) {
                    String comment;
                    Matcher matcher;
                    if (xmlStreamReader.next() != 5 || !(matcher = REGEXP_PATTERN.matcher(comment = xmlStreamReader.getText())).matches()) continue;
                    result = matcher.group(2);
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    xmlStreamReader.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                inputStream.close();
                xmlStreamReader.close();
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {}
        return result;
    }

    /*
     * Exception decompiling
     */
    public boolean isComponentDesciptor(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 12[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

