/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.componentdescription.impl;

import com.wuetherich.osgi.ds.annotations.internal.DsAnnotationException;
import com.wuetherich.osgi.ds.annotations.internal.builder.AbstractDsAnnotationAstVisitor;
import com.wuetherich.osgi.ds.annotations.internal.builder.ComponentProperty;
import com.wuetherich.osgi.ds.annotations.internal.componentdescription.AbstractTypeAccessor;
import com.wuetherich.osgi.ds.annotations.internal.componentdescription.impl.AbstractComponentDescription;
import com.wuetherich.osgi.ds.annotations.internal.componentdescription.impl.Messages;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.runtime.Assert;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.xmlns.scr.v1_0.ObjectFactory;
import org.osgi.xmlns.scr.v1_0.Tcomponent;
import org.osgi.xmlns.scr.v1_0.Timplementation;
import org.osgi.xmlns.scr.v1_0.TjavaTypes;
import org.osgi.xmlns.scr.v1_0.Tpolicy;
import org.osgi.xmlns.scr.v1_0.Tproperties;
import org.osgi.xmlns.scr.v1_0.Tproperty;
import org.osgi.xmlns.scr.v1_0.Tprovide;
import org.osgi.xmlns.scr.v1_0.Treference;
import org.osgi.xmlns.scr.v1_0.Tservice;

public class SCR_1_0_ComponentDescription
extends AbstractComponentDescription {
    private Tcomponent _tcomponent;
    private JAXBContext _jaxbContext;

    public SCR_1_0_ComponentDescription(AbstractTypeAccessor typeAccessor) {
        super(typeAccessor);
        try {
            this._jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Tcomponent.class, Timplementation.class, TjavaTypes.class, Tpolicy.class, Tproperties.class, Tproperty.class, Treference.class, Tservice.class});
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        this._tcomponent = new Tcomponent();
        Timplementation timplementation = new Timplementation();
        timplementation.setClazz(typeAccessor.getImplementationClassName());
        this._tcomponent.setImplementation(timplementation);
    }

    @Override
    public void onSetName(String value) {
        this._tcomponent.setName(value);
    }

    @Override
    public String getName() {
        return this._tcomponent.getName();
    }

    @Override
    public void onSetActivate(String methodName) {
        throw new DsAnnotationException(Messages.ComponentDescription_UNSUPPORTED_ANNOTATION_ACTIVATE);
    }

    @Override
    public void onSetDeactivate(String methodName) {
        throw new DsAnnotationException(Messages.ComponentDescription_UNSUPPORTED_ANNOTATION_DEACTIVATE);
    }

    @Override
    public void onSetModified(String methodName) {
        throw new DsAnnotationException(Messages.ComponentDescription_UNSUPPORTED_ANNOTATION_MODIFIED);
    }

    @Override
    public void onSetImmediate(Boolean value) {
        this._tcomponent.setImmediate(value);
    }

    @Override
    public void onSetEnabled(Boolean value) {
        this._tcomponent.setEnabled(value);
    }

    @Override
    public void onSetFactory(String value) {
        this._tcomponent.setFactory(value);
    }

    @Override
    public void onSetServiceFactory(Boolean value) {
        if (this._tcomponent.getService() == null) {
            this._tcomponent.setService(new Tservice());
        }
        this._tcomponent.getService().setServicefactory(value);
    }

    @Override
    public void onSetConfigurationPolicy(String lowerCase) {
        throw new DsAnnotationException(Messages.ComponentDescription_UNSUPPORTED_ATTRIBUTE_CONFIGURATIONPOLICY);
    }

    @Override
    public void onSetConfigurationPid(String configurationPid) {
        throw new DsAnnotationException(String.format(Messages.ComponentDescription_UNSUPPORTED_ATTRIBUTE_CONFIGURATIONPID, "1.0"));
    }

    @Override
    public void onAddProperties(String value) {
        Tproperties tproperties = new Tproperties();
        tproperties.setEntry(value);
        this._tcomponent.getPropertyOrProperties().add(tproperties);
    }

    @Override
    public void onAddProperty(List<String> orderedProperties, Map<String, List<ComponentProperty>> properties) {
        for (String name : orderedProperties) {
            Tproperty tproperty = new Tproperty();
            this._tcomponent.getPropertyOrProperties().add(tproperty);
            List<ComponentProperty> componentProperties = properties.get(name);
            ComponentProperty componentProperty = componentProperties.get(0);
            tproperty.setPropertyName(componentProperty.getName());
            if (componentProperty.getType() != null) {
                try {
                    tproperty.setPropertyType(TjavaTypes.fromValue(componentProperty.getType()));
                }
                catch (Exception exception) {
                    throw new DsAnnotationException(String.format(Messages.ComponentDescription_INVALID_PROPERTY_TYPE, componentProperty.getType()));
                }
            }
            if (componentProperties.size() == 1) {
                tproperty.setPropertyValue(componentProperty.getValue());
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder(System.getProperty("line.separator"));
            for (ComponentProperty prop : componentProperties) {
                stringBuilder.append(prop.getValue());
                stringBuilder.append(System.getProperty("line.separator"));
            }
            tproperty.setValue(stringBuilder.toString());
        }
    }

    @Override
    public void onSetService(String[] services) {
        if (services == null || services.length == 0) {
            this._tcomponent.setService(null);
        } else {
            if (this._tcomponent.getService() == null) {
                this._tcomponent.setService(new Tservice());
            }
            this._tcomponent.getService().getProvide().clear();
            String[] stringArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                String service = stringArray[n2];
                Tprovide tprovide = new Tprovide();
                tprovide.setInterface(service);
                this._tcomponent.getService().getProvide().add(tprovide);
                ++n2;
            }
        }
    }

    @Override
    public String toXml() {
        try {
            Marshaller marshaller = this._jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            if (this.getAssociatedSourceFile() != null) {
                try {
                    marshaller.setProperty("com.sun.xml.internal.bind.xmlHeaders", (Object)String.format("<!--Generated by DS Annotation Builder [%s]-->\n", this.getAssociatedSourceFile()));
                }
                catch (PropertyException propertyException) {
                    marshaller.setProperty("com.sun.xml.bind.xmlHeaders", (Object)String.format("<!--Generated by DS Annotation Builder [%s]-->\n", this.getAssociatedSourceFile()));
                }
            }
            StringWriter result = new StringWriter();
            marshaller.marshal(new ObjectFactory().createComponent(this._tcomponent), (Writer)result);
            return result.toString();
        }
        catch (JAXBException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean equals(InputStream inputStream) throws JAXBException {
        Unmarshaller unmarshaller = this._jaxbContext.createUnmarshaller();
        JAXBElement jaxbElement = (JAXBElement)unmarshaller.unmarshal(inputStream);
        Tcomponent tcomponent = (Tcomponent)jaxbElement.getValue();
        return SCR_1_0_ComponentDescription.equals(tcomponent, this._tcomponent);
    }

    public static boolean equals(Tcomponent comp1, Tcomponent comp2) {
        return comp1.equals(comp2);
    }

    @Override
    public void onAddReference(String service, String bind, String name, String cardinality, String policy, String policyOption, String unbind, String updated, String target) {
        Assert.isNotNull((Object)service);
        Assert.isNotNull((Object)bind);
        Treference reference = new Treference();
        reference.setInterface(service);
        reference.setBind(bind);
        reference.setName(name);
        for (Treference treference : this._tcomponent.getReference()) {
            if (!treference.getName().equals(reference.getName())) continue;
            throw new DsAnnotationException(String.format(Messages.ComponentDescription_REFERENCE_NAME_NOT_UNIQUE, reference.getName()));
        }
        if (this.isNotEmpty(unbind)) {
            if ("-".equals(unbind)) {
                reference.setUnbind(null);
            } else {
                if (!this.getTypeAccessor().checkMethodExists(unbind)) {
                    throw new DsAnnotationException(String.format(Messages.ComponentDescription_NON_EXISTING_UNBIND_METHOD, unbind));
                }
                this.getTypeAccessor().assertNoDsAnnotation(unbind);
                reference.setUnbind(unbind);
            }
        } else {
            String computedUnbindMethodName = AbstractDsAnnotationAstVisitor.computeUnbindMethodName(bind);
            if (this.getTypeAccessor().checkMethodExists(computedUnbindMethodName)) {
                this.getTypeAccessor().assertNoDsAnnotation(computedUnbindMethodName);
                reference.setUnbind(computedUnbindMethodName);
            }
        }
        if (this.isNotEmpty(updated)) {
            throw new DsAnnotationException(String.format(Messages.ComponentDescription_UNSUPPORTED_ATTRIBUTE_UPDATED, "1.0"));
        }
        if (this.isNotEmpty(target)) {
            try {
                FrameworkUtil.createFilter((String)target);
                reference.setTarget(target);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                throw new DsAnnotationException(String.format(Messages.ComponentDescription_INVALID_FILTER, target), "target");
            }
        }
        if (this.isNotEmpty(cardinality)) {
            if ("at_least_one".equalsIgnoreCase(cardinality)) {
                reference.setCardinality("1..n");
            } else if ("optional".equalsIgnoreCase(cardinality)) {
                reference.setCardinality("0..1");
            } else if ("mandatory".equalsIgnoreCase(cardinality)) {
                reference.setCardinality("1..1");
            } else if ("multiple".equalsIgnoreCase(cardinality)) {
                reference.setCardinality("0..n");
            }
        }
        if (this.isNotEmpty(policy)) {
            reference.setPolicy(Tpolicy.fromValue(policy.toLowerCase()));
        }
        if (this.isNotEmpty(policyOption)) {
            throw new DsAnnotationException(String.format(Messages.ComponentDescription_UNSUPPORTED_ATTRIBUTE_CONFIGURATIONPOLICY, "1.0"));
        }
        this._tcomponent.getReference().add(reference);
    }
}

