/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.actions;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class DisableNatureAction
implements IObjectActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
            for (Object element : structuredSelection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                try {
                    this.disableNature(project, structuredSelection.size() == 1);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void disableNature(IProject project, boolean b) throws CoreException {
        IProjectDescription description = project.getDescription();
        LinkedList<String> natures = new LinkedList<String>(Arrays.asList(description.getNatureIds()));
        Iterator iterator = natures.iterator();
        while (iterator.hasNext()) {
            if (!((String)iterator.next()).equals("com.wuetherich.osgi.ds.annotations.dsAnnotationNature")) continue;
            iterator.remove();
        }
        description.setNatureIds(natures.toArray(new String[0]));
        project.setDescription(description, null);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

