/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.preferences.fwk;

import com.wuetherich.osgi.ds.annotations.internal.preferences.fwk.AbstractPropertyAndPreferencesPage;
import com.wuetherich.osgi.ds.annotations.internal.preferences.fwk.RadioGroupDialogField;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class ConfigurationBlock
extends Composite {
    private AbstractPropertyAndPreferencesPage _page;

    public ConfigurationBlock(Composite parent, int style, AbstractPropertyAndPreferencesPage page) {
        super(parent, style);
        Assert.isNotNull((Object)((Object)page));
        this._page = page;
        this.createContent();
    }

    protected abstract void createContent();

    public AbstractPropertyAndPreferencesPage getPage() {
        return this._page;
    }

    public abstract void performDefaults();

    protected abstract String[] getPreferenceKeys();

    public abstract void initialize();

    public abstract boolean performOk();

    public boolean performApply() {
        return this.performOk();
    }

    public boolean performCancel() {
        return true;
    }

    public void performHelp() {
    }

    public boolean hasProjectSpecificOptions(IProject project) {
        IEclipsePreferences eclipsePreferences = new ProjectScope(project).getNode(this.getPage().getStoreIdentifier());
        String[] stringArray = this.getPreferenceKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (eclipsePreferences.get(string, null) != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected RadioGroupDialogField createRadioGroup(Composite parent, String label, String[] names, Object[] values, int layoutType) {
        return new RadioGroupDialogField(parent, label, names, values, layoutType);
    }

    protected Text createLabelTextField(Composite parent, String label, int textFieldWidrg) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)label);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(label);
        Text result = new Text(composite, 2052);
        GridData gd = new GridData();
        gd.widthHint = this.getPage().convertWidthInCharsToPixels(textFieldWidrg);
        result.setLayoutData((Object)gd);
        return result;
    }
}

