/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.builder;

import com.wuetherich.osgi.ds.annotations.internal.DsAnnotationException;
import com.wuetherich.osgi.ds.annotations.internal.DsAnnotationProblem;
import com.wuetherich.osgi.ds.annotations.xml.ObjectFactory;
import com.wuetherich.osgi.ds.annotations.xml.Tcomponent;
import com.wuetherich.osgi.ds.annotations.xml.TconfigurationPolicy;
import com.wuetherich.osgi.ds.annotations.xml.Timplementation;
import com.wuetherich.osgi.ds.annotations.xml.TjavaTypes;
import com.wuetherich.osgi.ds.annotations.xml.Tpolicy;
import com.wuetherich.osgi.ds.annotations.xml.Tproperties;
import com.wuetherich.osgi.ds.annotations.xml.Tproperty;
import com.wuetherich.osgi.ds.annotations.xml.Tprovide;
import com.wuetherich.osgi.ds.annotations.xml.Treference;
import com.wuetherich.osgi.ds.annotations.xml.Tservice;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class ComponentDescription {
    private static final String FIELD_NAME_TARGET = "target";
    private static final String FIELD_NAME_SERVICE = "service";
    private static final String MSG_NO_SUPERTYPE_S = "NO SUPERTYPE '%s'.";
    private static final String MSG_INVALID_FILTER_S = "Invalid filter '%s'.";
    private Tcomponent _tcomponent;
    private List<DsAnnotationProblem> _problems;
    private TypeDeclaration _typeDeclaration;
    private String _sourceFile;

    public ComponentDescription(TypeDeclaration typeDeclaration) {
        Assert.isNotNull((Object)typeDeclaration);
        try {
            CompilationUnit compilationUnit = (CompilationUnit)typeDeclaration.getParent();
            this._sourceFile = compilationUnit.getTypeRoot().getCorrespondingResource().getProjectRelativePath().toPortableString();
        }
        catch (JavaModelException javaModelException) {}
        this._typeDeclaration = typeDeclaration;
        this._tcomponent = new Tcomponent();
        this._problems = new LinkedList<DsAnnotationProblem>();
    }

    public boolean hasProblems() {
        return !this._problems.isEmpty();
    }

    public List<DsAnnotationProblem> getProblems() {
        return this._problems;
    }

    public void setName(String value) {
        this._tcomponent.setName(value);
    }

    public void setModifiedMethod(String methodName) {
        this._tcomponent.setModified(methodName);
    }

    public void setDeactivateMethod(String methodName) {
        this._tcomponent.setDeactivate(methodName);
    }

    public void setActivateMethod(String methodName) {
        this._tcomponent.setActivate(methodName);
    }

    public void setEnabled(Boolean value) {
        this._tcomponent.setEnabled(value);
    }

    public void setImmediate(Boolean value) {
        this._tcomponent.setImmediate(value);
    }

    public void setFactory(String value) {
        this._tcomponent.setFactory(value);
    }

    public void addProperties(String value) {
        Tproperties tproperties = new Tproperties();
        this._tcomponent.getPropertyOrProperties().add(tproperties);
        tproperties.setEntry(value);
    }

    public void addProperty(String keyValue) {
        String[] strings = keyValue.split("=");
        Tproperty tproperty = new Tproperty();
        this._tcomponent.getPropertyOrProperties().add(tproperty);
        String[] nameTypePair = strings[0].split(":");
        if (nameTypePair.length > 1) {
            tproperty.setPropertyName(nameTypePair[0]);
            tproperty.setPropertyType(TjavaTypes.fromValue(nameTypePair[1]));
        } else {
            tproperty.setPropertyName(strings[0]);
        }
        tproperty.setPropertyValue(strings[1]);
    }

    public void setService(String[] services) {
        if (services == null || services.length == 0) {
            this._tcomponent.setService(null);
        } else {
            if (this._tcomponent.getService() == null) {
                this._tcomponent.setService(new Tservice());
            }
            this._tcomponent.getService().getProvide().clear();
            String[] stringArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                String service = stringArray[n2];
                Assert.isNotNull((Object)service);
                if (!this.isInstanceOf(service)) {
                    throw new DsAnnotationException(String.format(MSG_NO_SUPERTYPE_S, service, FIELD_NAME_SERVICE));
                }
                Tprovide tprovide = new Tprovide();
                tprovide.setInterface(service);
                this._tcomponent.getService().getProvide().add(tprovide);
                ++n2;
            }
        }
    }

    public void addReference(String service, String bind, String name, String cardinality, String policy, String unbind, String target) {
        Assert.isNotNull((Object)service);
        Assert.isNotNull((Object)bind);
        Treference reference = new Treference();
        reference.setInterface(service);
        reference.setBind(bind);
        if (this.isNotEmpty(name)) {
            reference.setName(name);
        } else {
            name = bind;
            if (name.startsWith("add")) {
                name = name.substring("add".length());
            } else if (name.startsWith("set")) {
                name = name.substring("set".length());
            }
            reference.setName(name);
        }
        if (this.isNotEmpty(unbind)) {
            if ("-".equals(unbind)) {
                reference.setUnbind(null);
            } else {
                reference.setUnbind(unbind);
            }
        } else if (bind.startsWith("set")) {
            reference.setUnbind("unset" + bind.substring("set".length()));
        } else if (bind.startsWith("add")) {
            reference.setUnbind("remove" + bind.substring("add".length()));
        } else {
            reference.setUnbind("un" + bind);
        }
        if (this.isNotEmpty(target)) {
            try {
                FrameworkUtil.createFilter((String)target);
                reference.setTarget(target);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                throw new DsAnnotationException(String.format(MSG_INVALID_FILTER_S, target), FIELD_NAME_TARGET);
            }
        }
        if (this.isNotEmpty(cardinality)) {
            if ("at_least_one".equalsIgnoreCase(cardinality)) {
                reference.setCardinality("1..n");
            } else if ("optional".equalsIgnoreCase(cardinality)) {
                reference.setCardinality("0..1");
            } else if ("mandatory".equalsIgnoreCase(cardinality)) {
                reference.setCardinality("1..1");
            } else if ("multiple".equalsIgnoreCase(cardinality)) {
                reference.setCardinality("0..n");
            }
        }
        if (this.isNotEmpty(policy)) {
            reference.setPolicy(Tpolicy.fromValue(policy.toLowerCase()));
        }
        this._tcomponent.getReference().add(reference);
    }

    private boolean isNotEmpty(String name) {
        return name != null && name.trim().length() > 0;
    }

    public String toXml() {
        try {
            JAXBContext jaxbContext = ComponentDescription.createJAXBContext();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            if (this._sourceFile != null) {
                try {
                    marshaller.setProperty("com.sun.xml.internal.bind.xmlHeaders", (Object)String.format("<!--Generated by DS Annotation Builder [%s]-->\n", this._sourceFile));
                }
                catch (PropertyException propertyException) {
                    marshaller.setProperty("com.sun.xml.bind.xmlHeaders", (Object)String.format("<!--Generated by DS Annotation Builder [%s]-->\n", this._sourceFile));
                }
            }
            StringWriter result = new StringWriter();
            marshaller.marshal(new ObjectFactory().createComponent(this._tcomponent), (Writer)result);
            return result.toString();
        }
        catch (JAXBException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean equals(InputStream inputStream) throws JAXBException {
        JAXBContext jaxbContext = ComponentDescription.createJAXBContext();
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        JAXBElement jaxbElement = (JAXBElement)unmarshaller.unmarshal(inputStream);
        Tcomponent tcomponent = (Tcomponent)jaxbElement.getValue();
        return tcomponent.equals(this._tcomponent);
    }

    public void setComponentDefaults() {
        this._tcomponent.setName(this.getImplementationClassName());
        Timplementation timplementation = new Timplementation();
        timplementation.setClazz(this.getImplementationClassName());
        this._tcomponent.setImplementation(timplementation);
        List<String> stypes = this.getAllDirectlyImplementedSuperInterfaces();
        this.setService(stypes.toArray(new String[0]));
    }

    public void setConfigurationPolicy(String lowerCase) {
        TconfigurationPolicy tconfigurationPolicy = TconfigurationPolicy.fromValue(lowerCase);
        this._tcomponent.setConfigurationPolicy(tconfigurationPolicy);
    }

    public void setServiceFactory(Boolean value) {
        if (this._tcomponent.getService() == null) {
            this._tcomponent.setService(new Tservice());
        }
        this._tcomponent.getService().setServicefactory(value);
    }

    public String getName() {
        return this._tcomponent.getImplementation().getClazz();
    }

    public static JAXBContext createJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{Tcomponent.class, TconfigurationPolicy.class, Timplementation.class, TjavaTypes.class, Tpolicy.class, Tproperties.class, Tproperty.class, Treference.class, Tservice.class});
    }

    protected String getImplementationClassName() {
        return this._typeDeclaration.resolveBinding().getBinaryName();
    }

    protected List<String> getAllDirectlyImplementedSuperInterfaces() {
        LinkedList<String> result = new LinkedList<String>();
        for (Object type : this._typeDeclaration.superInterfaceTypes()) {
            result.add(((Type)type).resolveBinding().getBinaryName());
        }
        return result;
    }

    protected boolean isInstanceOf(String service) {
        return this.isInstanceOf(service, this._typeDeclaration.resolveBinding());
    }

    protected boolean isInstanceOf(String service, ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return false;
        }
        if (service.equals(typeBinding.getBinaryName())) {
            return true;
        }
        if (this.isInstanceOf(service, typeBinding.getSuperclass())) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding iface = iTypeBindingArray[n2];
            if (this.isInstanceOf(service, iface)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

