/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.builder;

import com.wuetherich.osgi.ds.annotations.internal.DsAnnotationException;
import com.wuetherich.osgi.ds.annotations.internal.DsAnnotationProblem;
import com.wuetherich.osgi.ds.annotations.internal.builder.ComponentProperty;
import com.wuetherich.osgi.ds.annotations.internal.builder.DsAnnotationAstVisitor;
import com.wuetherich.osgi.ds.annotations.xml.ObjectFactory;
import com.wuetherich.osgi.ds.annotations.xml.Tcomponent;
import com.wuetherich.osgi.ds.annotations.xml.TconfigurationPolicy;
import com.wuetherich.osgi.ds.annotations.xml.Timplementation;
import com.wuetherich.osgi.ds.annotations.xml.TjavaTypes;
import com.wuetherich.osgi.ds.annotations.xml.Tpolicy;
import com.wuetherich.osgi.ds.annotations.xml.TpolicyOption;
import com.wuetherich.osgi.ds.annotations.xml.Tproperties;
import com.wuetherich.osgi.ds.annotations.xml.Tproperty;
import com.wuetherich.osgi.ds.annotations.xml.Tprovide;
import com.wuetherich.osgi.ds.annotations.xml.Treference;
import com.wuetherich.osgi.ds.annotations.xml.Tservice;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class ComponentDescription {
    private static final String FIELD_NAME_TARGET = "target";
    private static final String FIELD_NAME_SERVICE = "service";
    private static final String MSG_NO_SUPERTYPE_S = "NO SUPERTYPE '%s'.";
    private static final String MSG_INVALID_FILTER_S = "Invalid filter '%s'.";
    private static final String MSG_NON_EXISTING_UNBIND_METHOD_S = "Non existing unbind method '%s'.";
    private static final String MSG_NON_EXISTING_UPDATED_METHOD_S = "Non existing updated method '%s'.";
    private Tcomponent _tcomponent;
    private List<DsAnnotationProblem> _problems;
    private TypeDeclaration _typeDeclaration;
    private String _sourceFile;

    public ComponentDescription(TypeDeclaration typeDeclaration) {
        Assert.isNotNull((Object)typeDeclaration);
        try {
            CompilationUnit compilationUnit = (CompilationUnit)typeDeclaration.getParent();
            this._sourceFile = compilationUnit.getTypeRoot().getCorrespondingResource().getProjectRelativePath().toPortableString();
        }
        catch (JavaModelException javaModelException) {}
        this._typeDeclaration = typeDeclaration;
        this._tcomponent = new Tcomponent();
        this._problems = new LinkedList<DsAnnotationProblem>();
    }

    public boolean hasProblems() {
        return !this._problems.isEmpty();
    }

    public List<DsAnnotationProblem> getProblems() {
        return this._problems;
    }

    public void setName(String value) {
        this._tcomponent.setName(value);
    }

    public void setModifiedMethod(String methodName) {
        this._tcomponent.setModified(methodName);
    }

    public void setDeactivateMethod(String methodName) {
        if (this._tcomponent.getActivate() != null && this._tcomponent.getActivate().equals(methodName)) {
            throw new DsAnnotationException(String.format("Activate and deactivate method have the same name '%s'.", methodName));
        }
        this._tcomponent.setDeactivate(methodName);
    }

    public void setActivateMethod(String methodName) {
        if (this._tcomponent.getDeactivate() != null && this._tcomponent.getDeactivate().equals(methodName)) {
            throw new DsAnnotationException(String.format("Activate and deactivate method have the same name '%s'.", methodName));
        }
        this._tcomponent.setActivate(methodName);
    }

    public void setEnabled(Boolean value) {
        this._tcomponent.setEnabled(value);
    }

    public void setImmediate(Boolean value) {
        this._tcomponent.setImmediate(value);
    }

    public void setFactory(String value) {
        this._tcomponent.setFactory(value);
    }

    public void addProperties(String value) {
        Tproperties tproperties = new Tproperties();
        this._tcomponent.getPropertyOrProperties().add(tproperties);
        tproperties.setEntry(value);
    }

    public void addProperty(Map<String, List<ComponentProperty>> properties) {
        for (String name : properties.keySet()) {
            Tproperty tproperty = new Tproperty();
            this._tcomponent.getPropertyOrProperties().add(tproperty);
            List<ComponentProperty> componentProperties = properties.get(name);
            ComponentProperty componentProperty = componentProperties.get(0);
            tproperty.setPropertyName(componentProperty.getName());
            if (componentProperty.getType() != null) {
                tproperty.setPropertyType(TjavaTypes.fromValue(componentProperty.getType()));
            }
            if (componentProperties.size() == 1) {
                tproperty.setPropertyValue(componentProperty.getValue());
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder(System.getProperty("line.separator"));
            for (ComponentProperty prop : componentProperties) {
                stringBuilder.append(prop.getValue());
                stringBuilder.append(System.getProperty("line.separator"));
            }
            tproperty.setValue(stringBuilder.toString());
        }
    }

    public void setService(String[] services) {
        if (services == null || services.length == 0) {
            this._tcomponent.setService(null);
        } else {
            if (this._tcomponent.getService() == null) {
                this._tcomponent.setService(new Tservice());
            }
            this._tcomponent.getService().getProvide().clear();
            String[] stringArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                String service = stringArray[n2];
                Assert.isNotNull((Object)service);
                if (!this.isInstanceOf(service)) {
                    throw new DsAnnotationException(String.format(MSG_NO_SUPERTYPE_S, service, FIELD_NAME_SERVICE));
                }
                Tprovide tprovide = new Tprovide();
                tprovide.setInterface(service);
                this._tcomponent.getService().getProvide().add(tprovide);
                ++n2;
            }
        }
    }

    public void addReference(String service, String bind, String name, String cardinality, String policy, String policyOption, String unbind, String updated, String target) {
        Assert.isNotNull((Object)service);
        Assert.isNotNull((Object)bind);
        Treference reference = new Treference();
        reference.setInterface(service);
        reference.setBind(bind);
        if (this.isNotEmpty(name)) {
            if (name == null || name.isEmpty()) {
                throw new DsAnnotationException(String.format("Invalid reference name '%s'.", reference.getName()));
            }
            reference.setName(name);
        } else {
            name = bind;
            if (name.startsWith("add")) {
                name = name.substring("add".length());
            } else if (name.startsWith("set")) {
                name = name.substring("set".length());
            } else if (name.startsWith("bind")) {
                name = name.substring("bind".length());
            }
            if (name == null || name.isEmpty()) {
                throw new DsAnnotationException(String.format("Invalid reference name '%s' (derived from bind method name '%s').", reference.getName(), bind));
            }
            reference.setName(name);
        }
        for (Treference treference : this._tcomponent.getReference()) {
            if (!treference.getName().equals(reference.getName())) continue;
            throw new DsAnnotationException(String.format("Reference name '%s' is not unique.", reference.getName()));
        }
        if (this.isNotEmpty(unbind)) {
            if ("-".equals(unbind)) {
                reference.setUnbind(null);
            } else {
                if (!this.checkMethodExists(unbind)) {
                    throw new DsAnnotationException(String.format(MSG_NON_EXISTING_UNBIND_METHOD_S, unbind));
                }
                this.assertNoDsAnnotation(unbind);
                reference.setUnbind(unbind);
            }
        } else {
            String computedUnbindMethodName = this.computeUnbindMethodName(bind);
            if (this.checkMethodExists(computedUnbindMethodName)) {
                this.assertNoDsAnnotation(computedUnbindMethodName);
                reference.setUnbind(computedUnbindMethodName);
            }
        }
        if (this.isNotEmpty(updated)) {
            if ("-".equals(updated)) {
                reference.setUpdated(null);
            } else {
                if (!this.checkMethodExists(updated)) {
                    throw new DsAnnotationException(String.format(MSG_NON_EXISTING_UPDATED_METHOD_S, updated));
                }
                reference.setUpdated(updated);
            }
        } else {
            String computedUpdatedMethodName = this.computeUpdatedMethodName(bind);
            if (this.checkMethodExists(computedUpdatedMethodName)) {
                reference.setUpdated(computedUpdatedMethodName);
            }
        }
        if (this.isNotEmpty(target)) {
            try {
                FrameworkUtil.createFilter((String)target);
                reference.setTarget(target);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                throw new DsAnnotationException(String.format(MSG_INVALID_FILTER_S, target), FIELD_NAME_TARGET);
            }
        }
        if (this.isNotEmpty(cardinality)) {
            if ("at_least_one".equalsIgnoreCase(cardinality)) {
                reference.setCardinality("1..n");
            } else if ("optional".equalsIgnoreCase(cardinality)) {
                reference.setCardinality("0..1");
            } else if ("mandatory".equalsIgnoreCase(cardinality)) {
                reference.setCardinality("1..1");
            } else if ("multiple".equalsIgnoreCase(cardinality)) {
                reference.setCardinality("0..n");
            }
        }
        if (this.isNotEmpty(policy)) {
            reference.setPolicy(Tpolicy.fromValue(policy.toLowerCase()));
        }
        if (this.isNotEmpty(policyOption)) {
            reference.setPolicyOption(TpolicyOption.fromValue(policyOption.toLowerCase()));
        }
        this._tcomponent.getReference().add(reference);
    }

    public String toXml() {
        try {
            JAXBContext jaxbContext = ComponentDescription.createJAXBContext();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            if (this._sourceFile != null) {
                try {
                    marshaller.setProperty("com.sun.xml.internal.bind.xmlHeaders", (Object)String.format("<!--Generated by DS Annotation Builder [%s]-->\n", this._sourceFile));
                }
                catch (PropertyException propertyException) {
                    marshaller.setProperty("com.sun.xml.bind.xmlHeaders", (Object)String.format("<!--Generated by DS Annotation Builder [%s]-->\n", this._sourceFile));
                }
            }
            StringWriter result = new StringWriter();
            marshaller.marshal(new ObjectFactory().createComponent(this._tcomponent), (Writer)result);
            return result.toString();
        }
        catch (JAXBException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean equals(InputStream inputStream) throws JAXBException {
        JAXBContext jaxbContext = ComponentDescription.createJAXBContext();
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        JAXBElement jaxbElement = (JAXBElement)unmarshaller.unmarshal(inputStream);
        Tcomponent tcomponent = (Tcomponent)jaxbElement.getValue();
        return ComponentDescription.equals(tcomponent, this._tcomponent);
    }

    public static boolean equals(Tcomponent comp1, Tcomponent comp2) {
        if (!comp1.equals(comp2)) {
            return false;
        }
        if (comp2.isSetActivate() != comp1.isSetActivate()) {
            return false;
        }
        return comp2.isSetDeactivate() == comp1.isSetDeactivate();
    }

    public void setComponentDefaults() {
        this._tcomponent.setName(this.getImplementationClassName());
        Timplementation timplementation = new Timplementation();
        timplementation.setClazz(this.getImplementationClassName());
        this._tcomponent.setImplementation(timplementation);
        List<String> stypes = this.getAllDirectlyImplementedSuperInterfaces();
        this.setService(stypes.toArray(new String[0]));
    }

    public void setConfigurationPolicy(String lowerCase) {
        TconfigurationPolicy tconfigurationPolicy = TconfigurationPolicy.fromValue(lowerCase);
        this._tcomponent.setConfigurationPolicy(tconfigurationPolicy);
    }

    public void setServiceFactory(Boolean value) {
        if (this._tcomponent.getService() == null) {
            this._tcomponent.setService(new Tservice());
        }
        this._tcomponent.getService().setServicefactory(value);
    }

    public String getName() {
        return this._tcomponent.getImplementation().getClazz();
    }

    public static JAXBContext createJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{Tcomponent.class, TconfigurationPolicy.class, Timplementation.class, TjavaTypes.class, Tpolicy.class, Tproperties.class, Tproperty.class, Treference.class, Tservice.class});
    }

    protected String getImplementationClassName() {
        return this._typeDeclaration.resolveBinding().getBinaryName();
    }

    protected List<String> getAllDirectlyImplementedSuperInterfaces() {
        LinkedList<String> result = new LinkedList<String>();
        for (Object type : this._typeDeclaration.superInterfaceTypes()) {
            result.add(((Type)type).resolveBinding().getBinaryName());
        }
        return result;
    }

    protected boolean isInstanceOf(String service) {
        return this.isInstanceOf(service, this._typeDeclaration.resolveBinding());
    }

    protected boolean isInstanceOf(String service, ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return false;
        }
        if (service.equals(typeBinding.getBinaryName())) {
            return true;
        }
        if (this.isInstanceOf(service, typeBinding.getSuperclass())) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding iface = iTypeBindingArray[n2];
            if (this.isInstanceOf(service, iface)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String computeUnbindMethodName(String bindName) {
        Assert.isNotNull((Object)bindName);
        if (bindName.startsWith("set")) {
            return "unset" + bindName.substring("set".length());
        }
        if (bindName.startsWith("add")) {
            return "remove" + bindName.substring("add".length());
        }
        return "un" + bindName;
    }

    private String computeUpdatedMethodName(String bindName) {
        Assert.isNotNull((Object)bindName);
        if (bindName.startsWith("set")) {
            return "updated" + bindName.substring("set".length());
        }
        if (bindName.startsWith("add")) {
            return "updated" + bindName.substring("add".length());
        }
        if (bindName.startsWith("bind")) {
            return "updated" + bindName.substring("bind".length());
        }
        return "updated" + bindName;
    }

    private boolean checkMethodExists(String computedUnbindMethodName) {
        MethodDeclaration[] methodDeclarationArray = this._typeDeclaration.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            if (methodDeclaration.getName().getFullyQualifiedName().equals(computedUnbindMethodName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isNotEmpty(String name) {
        return name != null && name.trim().length() > 0;
    }

    private void assertNoDsAnnotation(String methodName) {
        MethodDeclaration[] methodDeclarationArray = this._typeDeclaration.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            if (methodDeclaration.getName().getFullyQualifiedName().equals(methodName)) {
                for (Object modifier : methodDeclaration.modifiers()) {
                    if (!(modifier instanceof MarkerAnnotation) || !DsAnnotationAstVisitor.isDsAnnotation((Annotation)((MarkerAnnotation)modifier))) continue;
                    throw new DsAnnotationException(String.format("Method '%s' must not be annotated with the DS annotation '@%s'.", methodName, ((MarkerAnnotation)modifier).getTypeName()));
                }
            }
            ++n2;
        }
    }
}

