/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.builder;

import java.util.Stack;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

public abstract class AbstractDsAnnotationAstVisitor
extends ASTVisitor {
    private Stack<TypeDeclaration> _currentTypeDeclaration = new Stack();
    private MethodDeclaration _currentMethodDeclaration;
    private boolean _hasTypes = false;
    private IProject _project;

    public AbstractDsAnnotationAstVisitor(IProject project) {
        this._project = project;
    }

    public Stack<TypeDeclaration> getCurrentTypeDeclarationStack() {
        return this._currentTypeDeclaration;
    }

    public MethodDeclaration getCurrentMethodDeclaration() {
        return this._currentMethodDeclaration;
    }

    public final IProject getProject() {
        return this._project;
    }

    public final boolean hasTypes() {
        return this._hasTypes;
    }

    public boolean visit(TypeDeclaration node) {
        this._hasTypes = true;
        this._currentTypeDeclaration.push(node);
        return true;
    }

    public void endVisit(TypeDeclaration node) {
        this._currentTypeDeclaration.pop();
    }

    public boolean visit(MethodDeclaration node) {
        this._currentMethodDeclaration = node;
        return true;
    }

    public void endVisit(MethodDeclaration node) {
        this._currentMethodDeclaration = null;
    }

    public boolean visit(MarkerAnnotation node) {
        if (!this._currentTypeDeclaration.isEmpty()) {
            try {
                if (this.isComponentAnnotation((Annotation)node)) {
                    this.handleComponentAnnotation(node);
                } else if (this.isReferenceAnnotation((Annotation)node)) {
                    this.handleReferenceAnnotation(node);
                } else if (this.isActivateAnnotation((Annotation)node)) {
                    this.handleActivateAnnotation(node);
                } else if (this.isDeactivateAnnotation((Annotation)node)) {
                    this.handleDeactivateAnnotation(node);
                } else if (this.isModifiedAnnotation((Annotation)node)) {
                    this.handleModifiedAnnotation(node);
                }
            }
            catch (Exception e) {
                this.handleException((ASTNode)node, e);
            }
        }
        return this._currentMethodDeclaration == null;
    }

    public boolean visit(NormalAnnotation node) {
        if (!this._currentTypeDeclaration.isEmpty()) {
            try {
                if (this.isComponentAnnotation((Annotation)node)) {
                    this.handleComponentAnnotation(node);
                } else if (this.isReferenceAnnotation((Annotation)node)) {
                    this.handleReferenceAnnotation(node);
                }
            }
            catch (Exception e) {
                this.handleException((ASTNode)node, e);
            }
        }
        return this._currentMethodDeclaration == null;
    }

    public boolean visit(SingleMemberAnnotation node) {
        if (!this._currentTypeDeclaration.isEmpty()) {
            if (this.isComponentAnnotation((Annotation)node)) {
                throw new UnsupportedOperationException();
            }
            if (this.isReferenceAnnotation((Annotation)node)) {
                throw new UnsupportedOperationException();
            }
        }
        return this._currentMethodDeclaration == null;
    }

    public static String computeUnbindMethodName(String bindName) {
        Assert.isNotNull((Object)bindName);
        if (bindName.startsWith("set")) {
            return "unset" + bindName.substring("set".length());
        }
        if (bindName.startsWith("add")) {
            return "remove" + bindName.substring("add".length());
        }
        return "un" + bindName;
    }

    public static String computeUpdatedMethodName(String bindName) {
        Assert.isNotNull((Object)bindName);
        if (bindName.startsWith("set")) {
            return "updated" + bindName.substring("set".length());
        }
        if (bindName.startsWith("add")) {
            return "updated" + bindName.substring("add".length());
        }
        if (bindName.startsWith("bind")) {
            return "updated" + bindName.substring("bind".length());
        }
        return "updated" + bindName;
    }

    protected abstract void handleReferenceAnnotation(MarkerAnnotation var1);

    protected abstract void handleReferenceAnnotation(NormalAnnotation var1);

    protected abstract void handleModifiedAnnotation(MarkerAnnotation var1);

    protected abstract void handleDeactivateAnnotation(MarkerAnnotation var1);

    protected abstract void handleActivateAnnotation(MarkerAnnotation var1);

    protected abstract void handleComponentAnnotation(MarkerAnnotation var1);

    protected abstract void handleComponentAnnotation(NormalAnnotation var1);

    protected abstract void handleException(ASTNode var1, Exception var2);

    private boolean isReferenceAnnotation(Annotation annotation) {
        return this.getDsAnnotationFQName(annotation).equals(Reference.class.getName());
    }

    private boolean isComponentAnnotation(Annotation annotation) {
        return this.getDsAnnotationFQName(annotation).equals(Component.class.getName());
    }

    private boolean isActivateAnnotation(Annotation annotation) {
        return this.getDsAnnotationFQName(annotation).equals(Activate.class.getName());
    }

    private boolean isDeactivateAnnotation(Annotation annotation) {
        return this.getDsAnnotationFQName(annotation).equals(Deactivate.class.getName());
    }

    private boolean isModifiedAnnotation(Annotation annotation) {
        return this.getDsAnnotationFQName(annotation).equals(Modified.class.getName());
    }

    private String getDsAnnotationFQName(Annotation annotation) {
        return annotation.resolveTypeBinding().getQualifiedName();
    }
}

