/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.builder;

import com.wuetherich.osgi.ds.annotations.DsAnnotationVersion;
import com.wuetherich.osgi.ds.annotations.internal.DsAnnotationException;
import com.wuetherich.osgi.ds.annotations.internal.DsAnnotationProblem;
import com.wuetherich.osgi.ds.annotations.internal.builder.AbstractDsAnnotationAstVisitor;
import com.wuetherich.osgi.ds.annotations.internal.builder.DetectDsAnnotationVersionAstVisitor;
import com.wuetherich.osgi.ds.annotations.internal.builder.TypeDeclarationAccessor;
import com.wuetherich.osgi.ds.annotations.internal.componentdescription.ComponentDescriptionFactory;
import com.wuetherich.osgi.ds.annotations.internal.componentdescription.IComponentDescription;
import com.wuetherich.osgi.ds.annotations.internal.componentdescription.Reference;
import com.wuetherich.osgi.ds.annotations.internal.componentdescription.impl.AbstractComponentDescription;
import com.wuetherich.osgi.ds.annotations.internal.prefs.DsAnnotationsPreferences;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class DsAnnotationAstVisitor
extends AbstractDsAnnotationAstVisitor {
    private Map<TypeDeclaration, IComponentDescription> _descriptions = new HashMap<TypeDeclaration, IComponentDescription>();

    public DsAnnotationAstVisitor(IProject project) {
        super(project);
    }

    @Override
    public void endVisit(TypeDeclaration node) {
        try {
            IComponentDescription componentDescription = this.getCurrentComponentDescription();
            if (componentDescription != null) {
                ((AbstractComponentDescription)this.getCurrentComponentDescription()).execute();
            }
        }
        catch (Exception e) {
            this.handleException((ASTNode)node, e);
        }
        super.endVisit(node);
    }

    public Collection<IComponentDescription> getComponentDescriptions() {
        return this._descriptions.values();
    }

    @Override
    protected void handleReferenceAnnotation(MarkerAnnotation node) {
        String service = this.getCurrentMethodDeclaration().resolveBinding().getParameterTypes()[0].getBinaryName();
        String bind = this.getCurrentMethodDeclaration().getName().getFullyQualifiedName();
        Reference reference = new Reference(service, bind, null, null, null, null, null, null, null);
        this.getCurrentComponentDescription().getTypeAccessor().getReferences().add(reference);
    }

    @Override
    protected void handleReferenceAnnotation(NormalAnnotation node) {
        String name = null;
        String cardinality = null;
        String policy = null;
        String policyOption = null;
        String unbind = null;
        String updated = null;
        String target = null;
        String service = this.getCurrentMethodDeclaration().resolveBinding().getParameterTypes()[0].getBinaryName();
        String bind = this.getCurrentMethodDeclaration().getName().getFullyQualifiedName();
        for (Object object : node.values()) {
            IVariableBinding variableBinding;
            MemberValuePair pair = (MemberValuePair)object;
            String valueName = pair.getName().toString();
            if ("name".equals(valueName)) {
                name = pair.resolveMemberValuePairBinding().getValue().toString();
                continue;
            }
            if ("cardinality".equals(valueName)) {
                variableBinding = (IVariableBinding)pair.resolveMemberValuePairBinding().getValue();
                cardinality = variableBinding.getName().toLowerCase();
                continue;
            }
            if ("policy".equals(valueName)) {
                policy = ((IVariableBinding)pair.resolveMemberValuePairBinding().getValue()).getName();
                continue;
            }
            if ("policyOption".equals(valueName)) {
                variableBinding = (IVariableBinding)pair.resolveMemberValuePairBinding().getValue();
                policyOption = variableBinding.getName().toLowerCase();
                continue;
            }
            if ("service".equals(valueName)) {
                service = ((ITypeBinding)pair.resolveMemberValuePairBinding().getValue()).getBinaryName();
                continue;
            }
            if ("unbind".equals(valueName)) {
                unbind = pair.resolveMemberValuePairBinding().getValue().toString();
                continue;
            }
            if ("updated".equals(valueName)) {
                updated = pair.resolveMemberValuePairBinding().getValue().toString();
                continue;
            }
            if (!"target".equals(valueName)) continue;
            target = pair.resolveMemberValuePairBinding().getValue().toString();
        }
        Reference reference = new Reference(service, bind, name, cardinality, policy, policyOption, unbind, updated, target);
        this.getCurrentComponentDescription().getTypeAccessor().getReferences().add(reference);
    }

    @Override
    protected void handleModifiedAnnotation(MarkerAnnotation node) {
        this.getCurrentComponentDescription().getTypeAccessor().setModifiedMethodName(this.getCurrentMethodDeclaration().getName().getFullyQualifiedName());
    }

    @Override
    protected void handleDeactivateAnnotation(MarkerAnnotation node) {
        this.getCurrentComponentDescription().getTypeAccessor().setDeactivateMethodName(this.getCurrentMethodDeclaration().getName().getFullyQualifiedName());
    }

    @Override
    protected void handleActivateAnnotation(MarkerAnnotation node) {
        this.getCurrentComponentDescription().getTypeAccessor().setActivateMethodName(this.getCurrentMethodDeclaration().getName().getFullyQualifiedName());
    }

    @Override
    protected void handleComponentAnnotation(MarkerAnnotation node) {
        this.createNewComponentDeclaration((Annotation)node);
    }

    @Override
    protected void handleComponentAnnotation(NormalAnnotation node) {
        this.createNewComponentDeclaration((Annotation)node);
        for (Object object : node.values()) {
            Object[] properties;
            MemberValuePair pair = (MemberValuePair)object;
            if ("name".equals(pair.getName().toString())) {
                this.getCurrentComponentDescription().getTypeAccessor().setName((String)pair.resolveMemberValuePairBinding().getValue());
                continue;
            }
            if ("enabled".equals(pair.getName().toString())) {
                this.getCurrentComponentDescription().getTypeAccessor().setEnabled((Boolean)pair.resolveMemberValuePairBinding().getValue());
                continue;
            }
            if ("immediate".equals(pair.getName().toString())) {
                this.getCurrentComponentDescription().getTypeAccessor().setImmediate((Boolean)pair.resolveMemberValuePairBinding().getValue());
                continue;
            }
            if ("factory".equals(pair.getName().toString())) {
                this.getCurrentComponentDescription().getTypeAccessor().setFactory((String)pair.resolveMemberValuePairBinding().getValue());
                continue;
            }
            if ("configurationPid".equals(pair.getName().toString())) {
                this.getCurrentComponentDescription().getTypeAccessor().setConfigurationPid((String)pair.resolveMemberValuePairBinding().getValue());
                continue;
            }
            if ("configurationPolicy".equals(pair.getName().toString())) {
                IVariableBinding variableBinding = (IVariableBinding)pair.resolveMemberValuePairBinding().getValue();
                this.getCurrentComponentDescription().getTypeAccessor().setConfigurationPolicy(variableBinding.getName().toLowerCase());
                continue;
            }
            if ("property".equals(pair.getName().toString())) {
                properties = (Object[])pair.resolveMemberValuePairBinding().getValue();
                this.getCurrentComponentDescription().getTypeAccessor().setProperty(properties);
                continue;
            }
            if ("properties".equals(pair.getName().toString())) {
                properties = (Object[])pair.resolveMemberValuePairBinding().getValue();
                this.getCurrentComponentDescription().getTypeAccessor().setProperties(properties);
                continue;
            }
            if ("service".equals(pair.getName().toString())) {
                Object[] objects = (Object[])pair.resolveMemberValuePairBinding().getValue();
                LinkedList<String> services = new LinkedList<String>();
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object tb = objectArray[n2];
                    ITypeBinding typeBinding = (ITypeBinding)tb;
                    services.add(typeBinding.getBinaryName());
                    ++n2;
                }
                this.getCurrentComponentDescription().getTypeAccessor().setService(services.toArray(new String[0]));
                continue;
            }
            if (!"servicefactory".equals(pair.getName().toString())) continue;
            this.getCurrentComponentDescription().getTypeAccessor().setServiceFactory((Boolean)pair.resolveMemberValuePairBinding().getValue());
        }
    }

    @Override
    public void handleException(ASTNode astNode, Exception e) {
        DsAnnotationException annotationException;
        if (e instanceof DsAnnotationException && (annotationException = (DsAnnotationException)e).hasAnnotationField() && astNode instanceof NormalAnnotation) {
            for (Object object : ((NormalAnnotation)astNode).values()) {
                MemberValuePair pair = (MemberValuePair)object;
                String valueName = pair.getName().toString();
                if (!valueName.equals(annotationException.getAnnotationField())) continue;
                astNode = pair;
                break;
            }
        }
        if (this.getCurrentComponentDescription() != null) {
            this.getCurrentComponentDescription().getProblems().add(new DsAnnotationProblem(e.getMessage() != null ? e.getMessage() : "Error", astNode.getStartPosition(), astNode.getStartPosition() + astNode.getLength()));
        }
    }

    private IComponentDescription getCurrentComponentDescription() {
        return this._descriptions.get(this.getCurrentTypeDeclarationStack().peek());
    }

    private void createNewComponentDeclaration(Annotation annotation) {
        DetectDsAnnotationVersionAstVisitor visitor = new DetectDsAnnotationVersionAstVisitor(this.getProject());
        annotation.getRoot().accept((ASTVisitor)visitor);
        DsAnnotationVersion projectDsVersion = DsAnnotationsPreferences.getDsAnnotationVersion(this.getProject());
        DsAnnotationVersion effectiveVersion = visitor.getEffectiveVersion();
        IComponentDescription componentDescription = ComponentDescriptionFactory.createComponentDescription(new TypeDeclarationAccessor(this.getCurrentTypeDeclarationStack().peek()), this.getProject(), effectiveVersion.greaterThan(projectDsVersion) ? projectDsVersion : effectiveVersion);
        this._descriptions.put(this.getCurrentTypeDeclarationStack().peek(), componentDescription);
        if (visitor.hasAnnotationException()) {
            throw visitor.getAnnotationException();
        }
        if (visitor.hasSpecifiedXmlns() && visitor.getSpecifiedXmlns().greaterThan(DsAnnotationsPreferences.getDsAnnotationVersion(this.getProject()))) {
            throw new DsAnnotationException(String.format("XML namespace '%s' is higher than the XML namespace '%s' defined in the preferences.", visitor.getSpecifiedXmlns().getXmlns(), DsAnnotationsPreferences.getDsAnnotationVersion(this.getProject()).getXmlns()));
        }
    }
}

