/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.builder;

import com.wuetherich.osgi.ds.annotations.internal.DsAnnotationException;
import com.wuetherich.osgi.ds.annotations.internal.componentdescription.AbstractTypeAccessor;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.osgi.service.component.annotations.Component;

public class TypeDeclarationAccessor
extends AbstractTypeAccessor {
    private TypeDeclaration _typeDeclaration;

    public TypeDeclarationAccessor(TypeDeclaration typeDeclaration) {
        this._typeDeclaration = typeDeclaration;
    }

    @Override
    public String getAssociatedSourceFile() {
        try {
            CompilationUnit compilationUnit = (CompilationUnit)this._typeDeclaration.getParent();
            return compilationUnit.getTypeRoot().getCorrespondingResource().getProjectRelativePath().toPortableString();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getImplementationClassName() {
        return this._typeDeclaration.resolveBinding().getBinaryName();
    }

    @Override
    public List<String> getAllDirectlyImplementedSuperInterfaces() {
        LinkedList<String> result = new LinkedList<String>();
        for (Object type : this._typeDeclaration.superInterfaceTypes()) {
            result.add(((Type)type).resolveBinding().getBinaryName());
        }
        return result;
    }

    @Override
    public boolean isInstanceOf(String service) {
        return this.isInstanceOf(service, this._typeDeclaration.resolveBinding());
    }

    public boolean isInstanceOf(String service, ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return false;
        }
        if (service.equals(typeBinding.getBinaryName())) {
            return true;
        }
        if (this.isInstanceOf(service, typeBinding.getSuperclass())) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding iface = iTypeBindingArray[n2];
            if (this.isInstanceOf(service, iface)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean checkMethodExists(String computedUnbindMethodName) {
        MethodDeclaration[] methodDeclarationArray = this._typeDeclaration.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            if (methodDeclaration.getName().getFullyQualifiedName().equals(computedUnbindMethodName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void assertNoDsAnnotation(String methodName) {
        MethodDeclaration[] methodDeclarationArray = this._typeDeclaration.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            if (methodDeclaration.getName().getFullyQualifiedName().equals(methodName)) {
                for (Object modifier : methodDeclaration.modifiers()) {
                    if (!(modifier instanceof MarkerAnnotation) || !this.isDsAnnotation((Annotation)((MarkerAnnotation)modifier))) continue;
                    throw new DsAnnotationException(String.format("Method '%s' must not be annotated with the DS annotation '@%s'.", methodName, ((MarkerAnnotation)modifier).getTypeName()));
                }
            }
            ++n2;
        }
    }

    public boolean isDsAnnotation(Annotation annotation) {
        ITypeBinding typeBinding = annotation.resolveTypeBinding();
        if (typeBinding != null) {
            return Component.class.getPackage().getName().equals(annotation.resolveTypeBinding().getPackage().getName());
        }
        return false;
    }
}

