/*
 * Decompiled with CFR 0.152.
 */
package com.wuetherich.osgi.ds.annotations.internal.componentdescription.impl;

import com.wuetherich.osgi.ds.annotations.internal.componentdescription.IComponentDescription;
import com.wuetherich.osgi.ds.annotations.internal.componentdescription.IComponentDescriptionReader;
import com.wuetherich.osgi.ds.annotations.internal.componentdescription.IComponentDescriptionWriter;
import com.wuetherich.osgi.ds.annotations.internal.componentdescription.IManifestAndBuildPropertiesUpdater;
import com.wuetherich.osgi.ds.annotations.internal.prefs.DsAnnotationsPreferences;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ComponentDescriptionWriter
implements IComponentDescriptionWriter {
    private IComponentDescriptionReader _componentDescriptionReader;
    private IManifestAndBuildPropertiesUpdater _manifestAndBuildPropertiesUpdater;

    public ComponentDescriptionWriter(IComponentDescriptionReader componentDescriptionReader, IManifestAndBuildPropertiesUpdater manifestAndBuildPropertiesUpdater) {
        Assert.isNotNull((Object)componentDescriptionReader);
        Assert.isNotNull((Object)manifestAndBuildPropertiesUpdater);
        this._componentDescriptionReader = componentDescriptionReader;
        this._manifestAndBuildPropertiesUpdater = manifestAndBuildPropertiesUpdater;
    }

    @Override
    public void removeDanglingComponentDescriptions(IProject project) {
        for (Map.Entry<IPath, List<IPath>> entry : this._componentDescriptionReader.loadGeneratedDescriptionsMap(project).entrySet()) {
            try {
                IFile originFile = project.getFile(entry.getKey());
                if (originFile.exists()) continue;
                for (IPath path : entry.getValue()) {
                    try {
                        project.getFile(path).delete(true, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            this._manifestAndBuildPropertiesUpdater.updateManifestAndBuildProperties(project);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeComponentDescription(IProject project, IComponentDescription description) throws CoreException {
        IFile file = project.getFile(new Path("OSGI-INF").append((IPath)new Path(String.valueOf(description.getName()) + ".xml")));
        try {
            if (file.exists() && description.equals(file.getContents(true)) && this._componentDescriptionReader.containsDsAnnotationBuilderComment(file)) {
                return;
            }
        }
        catch (Exception exception) {}
        IFolder folder = project.getFolder("OSGI-INF");
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        if (file.exists()) {
            if (this.markGeneratedComponentDescriptionsAsDerived(project) && !file.isDerived()) {
                file.setDerived(true, null);
            }
            file.setContents((InputStream)new StringBufferInputStream(description.toXml()), 1, null);
        } else {
            this.deleteGeneratedFiles(project, (IPath)new Path(description.getAssociatedSourceFile()));
            file.create((InputStream)new StringBufferInputStream(description.toXml()), true, null);
            if (this.markGeneratedComponentDescriptionsAsDerived(project)) {
                file.setDerived(true, null);
            }
        }
        folder.refreshLocal(2, null);
        this._manifestAndBuildPropertiesUpdater.updateManifestAndBuildProperties(project);
    }

    @Override
    public void deleteGeneratedFiles(IProject project, IPath resource) throws CoreException {
        Map<IPath, List<IPath>> generatedFiles = this._componentDescriptionReader.loadGeneratedDescriptionsMap(project);
        List<IPath> result = generatedFiles.get(resource);
        if (result != null) {
            for (IPath path : result) {
                final IFile file = project.getFile(path);
                Job job = new Job(String.format("Deleting resource '%s'...", file.getName())){

                    protected IStatus run(IProgressMonitor monitor) {
                        long start = System.currentTimeMillis();
                        while (file.exists() && System.currentTimeMillis() - start < 7500L) {
                            try {
                                file.delete(true, null);
                            }
                            catch (Exception exception) {}
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
                long start = System.currentTimeMillis();
                while (file.exists() && System.currentTimeMillis() - start < 3500L) {
                    try {
                        file.delete(true, null);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this._manifestAndBuildPropertiesUpdater.updateManifestAndBuildProperties(project);
    }

    private boolean markGeneratedComponentDescriptionsAsDerived(IProject project) {
        return DsAnnotationsPreferences.getBoolean(project, "com.wuetherich.osgi.ds.annotations.derived", true);
    }
}

